/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitConfigProperties;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThemeCssCache {
    public static final String MEDIA_TYPE_ALL = "all";
    public static final String MEDIA_TYPE_PRINT = "print";
    public static final String MEDIA_TYPE_EDIT = "edit";
    protected static Cache<String, String> cache;
    protected static CacheSettings cacheSettings;

    protected static String check(String mediaType) {
        return BrikitString.isSet(mediaType) ? mediaType : MEDIA_TYPE_ALL;
    }

    public static String getBundleName(String themeName, String tweaker, String mediaType) {
        return themeName + "~~~" + tweaker + "~~~" + ThemeCssCache.check(mediaType);
    }

    public static String getCSS(String cacheKey) {
        return (String)ThemeCssCache.getCache().get((Object)cacheKey);
    }

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache(Confluence.getText("com.brikit.themepress.theme.css.cache"), (CacheLoader)new CacheLoader<String, String>(){

                public String load(String cacheKey) {
                    BrikitList<String> bits = BrikitString.split(cacheKey, "~~~");
                    String themeName = bits.first();
                    String tweaker = bits.size() > 1 ? (String)bits.get(1) : "";
                    String mediaType = bits.last();
                    ThemeProperties themeProperties = ThemeProperties.getThemeProperties(themeName);
                    boolean printMedia = ThemeCssCache.MEDIA_TYPE_PRINT.equalsIgnoreCase(mediaType);
                    boolean editMedia = ThemeCssCache.MEDIA_TYPE_EDIT.equalsIgnoreCase(mediaType);
                    String cssList = printMedia ? BrikitConfigProperties.getCssPrintFilesList() : (editMedia ? BrikitConfigProperties.getCssEditFilesList() : BrikitConfigProperties.getCssAllFilesList());
                    String cssFilesForThemePressPlugins = BrikitThemeSettings.cssFilesForThemePressPlugins(mediaType);
                    String cssFilesFromTheme = "";
                    if (printMedia) {
                        cssFilesFromTheme = themeProperties.getCssFilesForPrintMedia();
                    } else if (!editMedia) {
                        cssFilesFromTheme = themeProperties.getCssFilesForAllMedia();
                    }
                    StringBuilder buffer = new StringBuilder(500000);
                    Map velocityContext = BrikitThemeSettings.getCSSVelocityContext(themeProperties);
                    BrikitThemeSettings.readCssFiles(buffer, cssList, themeName, velocityContext, "Brikit Theme Press");
                    BrikitThemeSettings.readCssFiles(buffer, cssFilesForThemePressPlugins, themeName, velocityContext, "Third-Party Theme Press Plugin");
                    BrikitThemeSettings.readCssFiles(buffer, cssFilesFromTheme, themeName, velocityContext, "Theme Custom Code");
                    return buffer.toString().replaceAll("\\s*[a-zA-Z-]+\\s*:\\s*;\\s*", "").replaceAll("\\s*[a-zA-Z-]+\\s*:\\s*(\\$[a-zA-Z.]+\\s*)+;\\s*", "");
                }
            }, cacheSettings);
        }
        return cache;
    }

    public static void reset() {
        ThemeCssCache.getCache().removeAll();
    }

    protected static void reset(String cacheKey) {
        ThemeCssCache.getCache().remove((Object)cacheKey);
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(5L, TimeUnit.HOURS).maxEntries(50).build();
    }
}

