/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.util;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.MacroParser;
import com.brikit.themepress.model.PageWrapper;
import java.util.List;

public class PageDesignerResponse {
    public static final String SUCCESS_KEY = "success";
    public static final String ELEMENTS_KEY = "elements";
    public static final String ID_KEY = "id";
    public static final String TYPE_KEY = "type";
    public static final String CSS_KEY = "css";
    public static final String ACTION_KEY = "action";
    public static final String RELOAD_KEY = "reload";
    public static final String CONTAINS_KEY = "contains";
    public static final String HTML_KEY = "html";

    public static JSONObject jsonResponse(AbstractPage abstractPage, boolean success, List<MacroDefinition> macros, String action, boolean reload) throws XhtmlException {
        JSONObject json = new JSONObject();
        json.put(SUCCESS_KEY, success);
        json.put(RELOAD_KEY, reload);
        json.put(ELEMENTS_KEY, (Object)PageDesignerResponse.jsonForElements(abstractPage, macros, action));
        return json;
    }

    public static JSONObject jsonForElement(AbstractPage abstractPage, MacroDefinition elementMacro, String action) throws XhtmlException {
        PageWrapper pageWrapper = PageWrapper.get(abstractPage);
        JSONObject json = new JSONObject();
        json.put(ID_KEY, (Object)pageWrapper.getId(elementMacro));
        json.put(TYPE_KEY, (Object)PageDesignerResponse.elementType(elementMacro));
        json.put(ACTION_KEY, (Object)action);
        json.put(CSS_KEY, (Object)PageDesignerResponse.cssForElement(abstractPage, elementMacro));
        List<MacroDefinition> contains = null;
        if (elementMacro.getName().equals("content-layer")) {
            contains = pageWrapper.columnsFromStorageFormat(elementMacro.getBodyText());
        } else if (elementMacro.getName().equals("content-column")) {
            contains = pageWrapper.blocksFromStorageFormat(elementMacro.getBodyText());
        }
        if (contains != null) {
            json.put(CONTAINS_KEY, (Object)PageDesignerResponse.jsonForElements(abstractPage, contains, action));
        }
        return json;
    }

    public static JSONArray jsonForElements(AbstractPage abstractPage, List<MacroDefinition> macros, String action) throws XhtmlException {
        JSONArray json = new JSONArray();
        for (MacroDefinition macro : macros) {
            json.put((Object)PageDesignerResponse.jsonForElement(abstractPage, macro, action));
        }
        return json;
    }

    public static JSONObject cssForElement(AbstractPage abstractPage, MacroDefinition elementMacro) throws XhtmlException {
        JSONObject json = new JSONObject();
        json.put("width", (Object)MacroParser.getStringParameter(elementMacro, "width"));
        return json;
    }

    protected static String elementType(MacroDefinition macro) {
        return macro.getName().contains("-") ? macro.getName().split("-")[1] : "";
    }
}

