/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitDate;
import java.util.Calendar;
import java.util.Map;

public class LocalDateTimeMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/local-date-time.vm";
    public static final String FORMATTED_DATE = "formattedDate";
    public static final String FORMATTED_TIME = "formattedTime";
    public static final String DAY_TIME = "daytime";
    public static final String ALL_TIME_ZONES = "timeZones";
    public static final String TIMEZONE_PARAM = "timezone";
    public static final String DATE_FORMAT_PARAM = "date-format";
    public static final String TIME_FORMAT_PARAM = "time-format";
    public static final String DAY_START = "day-start";
    public static final String DAY_END = "day-end";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        Calendar now = Confluence.getTimeNow(Confluence.getSystemTimeZone());
        if (macroContext.hasStringValue(TIMEZONE_PARAM)) {
            TimeZone timeZone = TimeZone.getInstance((String)macroContext.stringValue(TIMEZONE_PARAM));
            String format = macroContext.stringValue(DATE_FORMAT_PARAM, "MMM d, Y");
            macroContext.velocityContextAdd(FORMATTED_DATE, BrikitDate.formatDateTime(now, timeZone, format, true));
            format = macroContext.stringValue(TIME_FORMAT_PARAM, "HH:mm z");
            macroContext.velocityContextAdd(FORMATTED_TIME, BrikitDate.formatDateTime(now, timeZone, format, true));
            String startTime = macroContext.stringValue(DAY_START, "08:00");
            String endTime = macroContext.stringValue(DAY_END, "17:00");
            String nowTime = BrikitDate.formatDateTime(now, timeZone, "HH:mm", true);
            macroContext.velocityContextAdd(DAY_TIME, nowTime.compareTo(startTime) >= 0 && nowTime.compareTo(endTime) <= 0);
        } else {
            macroContext.velocityContextAdd(ALL_TIME_ZONES, TimeZone.getSortedTimeZones());
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }
}

