/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.util.SpaceComparator;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitLabel;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitOrderedMap;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ListSpacesMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/list-spaces.vm";
    public static final String FILTER_PARAM = "filter";
    public static final String CATEGORIES_PARAM = "categories";
    public static final String EXCLUDE_CATEGORIES_PARAM = "exclude-categories";
    public static final String SHOW_CATEGORIES_PARAM = "show-categories";
    public static final String CATEGORY_NAMES_PARAM = "category-names";
    public static final String SHOW_ARCHIVED_PARAM = "show-archived";
    public static final String SHOW_CATEGORIES_ONLY_PARAM = "show-categories-only";
    public static final String ALL_CATEGORIES_WILDCARD = "@all";
    public static final String FILTER_ALL = "all";
    public static final String FILTER_CATEGORY = "category";
    public static final String FILTER_FAVORITE = "favorites";
    public static final String FILTER_NEW = "new";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.booleanValue("no-bullets")) {
            macroContext.velocityContextAdd("noBullets", "true");
        }
        boolean showArchived = macroContext.booleanValue(SHOW_ARCHIVED_PARAM);
        boolean showCategoriesOnly = macroContext.booleanValue(SHOW_CATEGORIES_ONLY_PARAM);
        String filter = macroContext.stringValue(FILTER_PARAM, FILTER_ALL);
        List<Object> spaces = new ArrayList();
        if (!showCategoriesOnly) {
            if (FILTER_ALL.equalsIgnoreCase(filter)) {
                spaces = new ArrayList<Space>(Confluence.permittedSpaces());
            } else if (FILTER_CATEGORY.equalsIgnoreCase(filter)) {
                String categoriesString = BrikitString.decodeSpecialCharacters(macroContext.stringValue(CATEGORIES_PARAM));
                String excludeCategoriesString = BrikitString.decodeSpecialCharacters(macroContext.stringValue(EXCLUDE_CATEGORIES_PARAM));
                spaces = Confluence.spacesWithCategories(BrikitString.splitCommaSeparated(categoriesString), BrikitString.splitCommaSeparated(excludeCategoriesString));
            } else if (FILTER_FAVORITE.equalsIgnoreCase(filter)) {
                spaces = Confluence.favoriteSpaces();
            } else if (FILTER_NEW.equalsIgnoreCase(filter)) {
                spaces = Confluence.newSpaces();
            }
        }
        if (!showArchived) {
            ListIterator spacesIterator = spaces.listIterator();
            while (spacesIterator.hasNext()) {
                Space space = (Space)spacesIterator.next();
                if (space.getSpaceStatus() != SpaceStatus.ARCHIVED) continue;
                spacesIterator.remove();
            }
        }
        HashMap<String, String> mappedNames = new HashMap<String, String>();
        for (String labelPair : macroContext.commaSeparatedListValue(CATEGORY_NAMES_PARAM)) {
            BrikitList<String> pair = new BrikitList<String>((List<String>)BrikitString.split(labelPair, "="));
            if (pair.size() != 2) continue;
            mappedNames.put(pair.first(), pair.last());
        }
        Collections.sort(spaces, new SpaceComparator());
        if (!macroContext.hasStringValue(SHOW_CATEGORIES_PARAM)) {
            macroContext.velocityContextAdd("spaces", spaces);
        } else {
            BrikitOrderedMap<String, String> categoryEntries = new BrikitOrderedMap<String, String>();
            List<String> showCategories = ALL_CATEGORIES_WILDCARD.equalsIgnoreCase(macroContext.stringValue(SHOW_CATEGORIES_PARAM)) ? Confluence.getSpaceCategoriesAsStrings() : macroContext.commaSeparatedListValue(SHOW_CATEGORIES_PARAM);
            HashMap spacesByCategory = new HashMap(showCategories.size());
            for (String category : showCategories) {
                categoryEntries.put(category, mappedNames.containsKey(category) ? (String)mappedNames.get(category) : BrikitLabel.humanize(category));
                ArrayList<Space> categorySpaces = new ArrayList<Space>();
                for (Space space : spaces) {
                    if (!Confluence.spaceHasCategory(space.getKey(), category)) continue;
                    categorySpaces.add(space);
                }
                spacesByCategory.put(category, categorySpaces);
            }
            macroContext.velocityContextAdd(CATEGORIES_PARAM, categoryEntries);
            macroContext.velocityContextAdd("spacesByCategory", spacesByCategory);
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

