/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;

public class ArchitectPageVisibility {
    protected static final String ARCHITECT_PAGE_SPACE_CATEGORIES_KEY = "com.brikit.themepress.architect.page.space.categories";

    public static void addArchitectTabAccessGroup(String category, AbstractPage abstractPage) {
        BrikitList<String> categories = ArchitectPageVisibility.architectPageSpaceCategories(abstractPage);
        if (categories.contains(category)) {
            return;
        }
        categories.add(category);
        ArchitectPageVisibility.saveArchitectPageSpaceCategories(categories, abstractPage);
    }

    public static boolean isVisible(AbstractPage abstractPage, String spaceKey) {
        BrikitList<String> categories = ArchitectPageVisibility.architectPageSpaceCategories(abstractPage);
        return categories.isEmpty() || Confluence.spaceHasAnyCategory(spaceKey, categories);
    }

    public static void removeArchitectTabAccessGroup(String category, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        BrikitList<String> categories = ArchitectPageVisibility.architectPageSpaceCategories(abstractPage);
        if (!categories.contains(category)) {
            return;
        }
        categories.remove(category);
        ArchitectPageVisibility.saveArchitectPageSpaceCategories(categories, abstractPage);
    }

    protected static void saveArchitectPageSpaceCategories(BrikitList<String> categories, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        Confluence.saveRawData(ARCHITECT_PAGE_SPACE_CATEGORIES_KEY, categories.join(","), abstractPage);
    }

    public static BrikitList<String> architectPageSpaceCategories(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return new BrikitList<String>();
        }
        return BrikitString.splitCommaSeparated(Confluence.getRawData(ARCHITECT_PAGE_SPACE_CATEGORIES_KEY, abstractPage));
    }
}

