/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.targetedsearch.macros.AbstractFacetAwareMacro;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.ThemePressAwareness;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LabelSelectFieldMacro
extends AbstractFacetAwareMacro {
    protected static final String FILTER_GROUP_KEY = "filter-group";
    public static final String TEMPLATE_NAME = "targeted-search/templates/label-select-field.vm";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        this.validateVisibleFilterGroups(macroContext);
        macroContext.velocityContextAdd((Object)"hasPermission", (Object)Confluence.canEdit((AbstractPage)macroContext.getPage()));
        List<Object> filterGroups = new ArrayList();
        if ("@current".equalsIgnoreCase(macroContext.stringValue(FILTER_GROUP_KEY)) && !ThemePressAwareness.isArchitectSpace(this.getCurrentSpaceKey(macroContext))) {
            Space currentSpace = macroContext.getSpace();
            filterGroups = FilterGroup.getFilterGroupsForSpace(currentSpace);
        } else {
            for (String filterGroupName : macroContext.commaSeparatedListValue(FILTER_GROUP_KEY)) {
                FilterGroup filterGroup = FilterGroup.getFilterGroupByName(filterGroupName);
                if (filterGroup == null) continue;
                filterGroups.add(filterGroup);
            }
        }
        macroContext.velocityContextAdd((Object)"filter-groups", filterGroups);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

