/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.brikit.core.confluence.Confluence;
import com.brikit.pinboards.model.AbstractActiveObjectsModel;
import com.brikit.pinboards.model.ao.ShareAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class Share
extends AbstractActiveObjectsModel {
    protected ShareAO activeObject;
    protected ActiveObjects activeObjects;

    protected Share(ActiveObjects activeObjects, ShareAO activeObject) {
        this.setActiveObjects(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static Share create(ActiveObjects activeObjects, long entityId, ConfluenceUser user, long time) {
        Share share = Share.getShare(activeObjects, entityId, user, time);
        if (share != null) {
            return share;
        }
        ShareAO shareAO = (ShareAO)activeObjects.create(ShareAO.class, new DBParam[0]);
        shareAO.setEntityId(entityId);
        shareAO.setUserKey(Confluence.getUserKey((ConfluenceUser)user).getStringValue());
        shareAO.setTime(time);
        share = new Share(activeObjects, shareAO);
        share.save();
        return share;
    }

    public static Share getShare(ActiveObjects activeObjects, long entityId, ConfluenceUser user, long time) {
        String query = "ENTITY_ID = ? and USER_KEY = ? and TIME = ?";
        List<Share> found = Share.getShares(activeObjects, Query.select().where(query, new Object[]{entityId, Confluence.getUserKeyString((User)user), time}));
        return found.isEmpty() ? null : found.get(0);
    }

    public static List<Share> getSharesByTimestamp(ActiveObjects activeObjects, Long startTime, Long endTime) {
        String query = "TIME >= ? and TIME <= ?";
        return Share.getShares(activeObjects, Query.select().where(query, new Object[]{startTime, endTime}));
    }

    public static List<Share> getShares(ActiveObjects activeObjects, Query aQuery) {
        ArrayList<Share> shares = new ArrayList<Share>();
        List<ShareAO> shareAOs = Arrays.asList((ShareAO[])activeObjects.find(ShareAO.class, aQuery));
        for (ShareAO shareAO : shareAOs) {
            shares.add(new Share(activeObjects, shareAO));
        }
        Collections.sort(shares, new Comparator<Share>(){

            @Override
            public int compare(Share share1, Share share2) {
                return share2.getTime().compareTo(share1.getTime());
            }
        });
        return shares;
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public ContentEntityObject getContentEntity() {
        return Confluence.getContentEntity((long)this.getEntityId());
    }

    public ShareAO getActiveObject() {
        return this.activeObject;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    @Override
    public int getID() {
        return this.getActiveObject().getID();
    }

    public ConfluenceUser getUser() {
        return Confluence.getConfluenceUserByUserKey((String)this.getUserKey());
    }

    public String getUserKey() {
        return this.getActiveObject().getUserKey();
    }

    public long getEntityId() {
        return this.getActiveObject().getEntityId();
    }

    public Date getTime() {
        return new Date(this.getActiveObject().getTime());
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(ShareAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }
}

