(function ($) {
	
	ContentFlowEditDialog = function (e) {
		var self = this;
		// Don't rely on event.target; use this instead
		var target = $(e.target) || $(e.srcElement);
		self.workflowId = target.closest("ul").data("workflow-id");
		self.trigger = target;
	};
	
	Object.assign(ContentFlowEditDialog.prototype, ContentFlowModalDialog.prototype, {
		
		adjustVisibility: function () {
			this.saveWorkflowButton().adjustAttr("disabled", "disabled", !this.hasChanges());
			// Control visibility add-approval-step-button
			this.find("#add-approval-step-button").showIf(this.isWorkflowTabSelected());
		},
		
		find: function(selector) {
			var element = this.dialog.$k;
			return selector ? $(selector, element) : element;
		},
		
		getDialogUrl: function () {
			return "/plugins/contentflow/updateworkflowdialog.action";
		},
		
		getDialogUrlData: function () {
			var self = this;
			
			var data = {
				spaceKey: ContentFlow.spaceKey,
				workflowId: self.workflowId
			};
			
			return data;
		},
		
		hasChanges: function () {
			return this.configurePanel.isDirty || this.workflowPanel.isDirty;
		},

		initializeDialog: function (response) {
			
			var options = {
				size: "xlarge", 
				// title: ContentFlow.getText("com.brikit.contentflow.edit.workflow.template.title"),
				title: ContentFlow.getText("com.brikit.contentflow.define.workflow.template.title"),
				id: "content-flow-dialog",
				okButton: ContentFlow.getText("com.brikit.contentflow.save.name"), 
				closeWithButtonOnly: true
			};
			
			// Initialize my dialog and my configurePanel
	        this.dialog = ContentFlow.Dialog2.dialog(response, options, this.saveWorkflow.bind(this), null, ContentFlow.confirmLosingChangesSimple);
			this.configurePanel = new ContentFlowConfigurePanel(this);
			
			this.find("#manage-content-flow-form").addClass("editing");

			// Add a class handle to Save button (for handy lookup)
			this.find(".button-panel-button").addClass("save-workflow-button");

			AJS.tabs.setup();
			this.find("#space-workflows-tabs").on("tabSelect", ".menu-item a", this.adjustVisibility.bind(this));
			
			$("#content-flow-dialog, #content-flow-dialog .dialog-panel-body").css("height", "auto");
			
			// Initialize my workflowPanel
			this.workflowPanel = new ContentFlowWorkflowPanel(this);

			this.adjustVisibility();
				    
		},
		
		isWorkflowTabSelected: function () {
			return this.find("#workflow-details.active-pane").length;
		},
		
        // saveWorkflow: function () {
        //     var self = this;
        //     // TODO:  Move saveWorkflow from panel to this dialog -- adding a function on workflow-panel to marshall the input,
        //     // which is currently happening in the saveWorkflow(dialog) function
        //     self.workflowPanel.saveWorkflow(self);
        //     self.close();
        // },
		
		saveWorkflow: function(dialog) {
			var self = this;
			
			if (!self.validateInput(true)) return false;
			
			var workflowId = ContentFlow.$(".aui-progress-tracker").data("workflow-id");
			var labels = [];
			$(".workflow-labels .add-label-field").each(function () { labels.push($(this).val()); });
			var existingLabels = this.configurePanel.find(".aui-label-closeable");
			existingLabels.each(function () {labels.push($(this).text()); });
			
			var workflow = new ContentFlow.Workflow(
				workflowId, 
				ContentFlow.$("#template-name").val(),
				ContentFlow.$("#workflow-visibility-option").val(),
                ContentFlow.$("#workflow-remove-permissions").val(), 
                ContentFlow.$("#workflow-remove-permissions-user").val(), 
				ContentFlow.$("#workflow-space-key").val(),
				ContentFlow.$("#template-space-categories-field").val(),
				ContentFlow.$("#workflow-publishing").val(),
                ContentFlow.$("#template-entry-page-status-field").val(),
				labels.join(", "),
                ContentFlow.$("#template-exit-page-status-field").val()
			);
			ContentFlow.$(".approval-step").each(function () {
				var approvalStep = new ContentFlow.ApprovalStep(this);
				if (approvalStep.reviewers.length) workflow.approvalSteps.push(approvalStep);
			});
			
			var data = {
				spaceKey: ContentFlow.spaceKey,
				json: JSON.stringify(workflow)
			};
			if (ContentFlow.pageId) data.pageId = ContentFlow.pageId;
			if (workflowId) data.workflowId = workflowId;
            ContentFlow.addToken(data);
			self.saveWorkflowButton().spin();
            jQuery.ajax({
                url: ContentFlow.contextPath + "/plugins/contentflow/save.action",
                data: data,
                type: "POST",
				success: function (response) {
					if (response.indexOf("errorMessage") == -1) {
						location.reload(true);
					}
					else {
						AJS.flag({
                           type: "error",
						   body: response
						});
					}
				},
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while saving.", errorThrown);
					self.saveWorkflowButton().spinStop();
                },
				complete: ContentFlow.refreshContentFlowHolder
            });

            return false;
        },
		
		saveWorkflowButton: function () {
			return this.find(".save-workflow-button");
		},
		
		validateInput: function (showErrors) {
			return this.configurePanel.validateInput(showErrors) && this.workflowPanel.validateInput(showErrors);
		}
		
	});


})(jQuery);
