/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.service.LocalNotificationService;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.PageReviewFeedback;
import com.brikit.contentflow.model.PageReviewer;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageApprovalStep {
    protected ApprovalStep approvalStep;
    protected PageWorkflow pageWorkflow;
    protected List<PageReviewer> pageReviewers;
    protected ActiveObjects activeObjects;

    public PageApprovalStep(ApprovalStep approvalStep, PageWorkflow pageWorkflow) {
        this.approvalStep = approvalStep;
        this.pageWorkflow = pageWorkflow;
        this.activeObjects = pageWorkflow.getActiveObjects();
    }

    public void clearApprovals(LocalNotificationService notificationService) {
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            if (!pageReviewer.isApproved() && !pageReviewer.isRejected()) continue;
            pageReviewer.clearReviewerFeedback(notificationService);
        }
    }

    public boolean currentUserNeedsToApprove() {
        if (Confluence.isAnonymousUser()) {
            return false;
        }
        if (this.isComplete()) {
            return false;
        }
        return this.isPublishingWorkflowEditor() && this.isFirstStep() || this.isCurrentUserReviewer() && this.pageReviewerForCurrentUser().isWaitingForUser();
    }

    protected void forceComplete() {
        if (this.isComplete()) {
            return;
        }
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            pageReviewer.forceApproval();
        }
    }

    public AbstractPage getAbstractPage() {
        return this.getPageWorkflow().getAbstractPage();
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public ApprovalStep getApprovalStep() {
        return this.approvalStep;
    }

    public String getLabel() {
        return this.getApprovalStep().getLabel();
    }

    public List<PageReviewer> getPageReviewers() {
        if (this.pageReviewers == null) {
            List<Reviewer> reviewers = this.getReviewers();
            this.pageReviewers = new ArrayList<PageReviewer>(reviewers.size());
            for (Reviewer reviewer : reviewers) {
                this.pageReviewers.add(new PageReviewer(this.getActiveObjects(), reviewer, this));
            }
        }
        return this.pageReviewers;
    }

    public PageStatus getPageStatus() {
        return this.getApprovalStep().getPageStatus();
    }

    public PageWorkflow getPageWorkflow() {
        return this.pageWorkflow;
    }

    public BrikitList<PageReviewFeedback> getReviewerComments() {
        BrikitList pageReviewFeedbacks = new BrikitList();
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            pageReviewFeedbacks.addAll(pageReviewer.getPageReviewFeedback());
        }
        Collections.sort(pageReviewFeedbacks, PageReviewFeedback.DateOrder);
        return pageReviewFeedbacks;
    }

    public List<Reviewer> getReviewers() {
        return this.getApprovalStep().getReviewers();
    }

    public boolean hasApprovalActivity() {
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            if (!pageReviewer.isApproved() && !pageReviewer.isRejected()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNextStep() {
        return this.getApprovalStep().hasNextStep();
    }

    public boolean isComplete() {
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            if (pageReviewer.isApproved()) continue;
            return false;
        }
        return true;
    }

    public boolean isCurrentUserReviewer() {
        return this.getApprovalStep().isCurrentUserReviewer();
    }

    public boolean isFirstStep() {
        return this.getApprovalStep().isFirstStep();
    }

    public boolean isPublishingWorkflowEditor() {
        return this.getApprovalStep().isPublishingEditorOrWorkflowEditor(this.getPageWorkflow().getAbstractPage());
    }

    public boolean isRejected() {
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            if (!pageReviewer.isRejected()) continue;
            return true;
        }
        return false;
    }

    public PageApprovalStep nextStep() {
        return new PageApprovalStep(this.getApprovalStep().nextStep(), this.getPageWorkflow());
    }

    public PageReviewer pageReviewerForUser(ConfluenceUser user) {
        Reviewer reviewer = this.reviewerForUser(user);
        return reviewer == null ? null : new PageReviewer(this.getActiveObjects(), reviewer, this);
    }

    public PageReviewer pageReviewerForCurrentUser() {
        return this.pageReviewerForUser(Confluence.getConfluenceUser());
    }

    public PageApprovalStep previousStep() {
        return new PageApprovalStep(this.getApprovalStep().previousStep(), this.getPageWorkflow());
    }

    protected void removeResets() {
        for (PageReviewer pageReviewer : this.getPageReviewers()) {
            pageReviewer.removeResets();
        }
    }

    public void reviewerApproved(LocalNotificationService notificationService, PageReviewer pageReviewer) {
        if (this.isComplete()) {
            if (this.hasNextStep()) {
                this.getPageWorkflow().stepForward();
                this.getPageWorkflow().getCurrentPageApprovalStep().clearApprovals(notificationService);
            } else if (this.getPageWorkflow().isPublishing()) {
                this.getPageWorkflow().publish();
                this.getPageWorkflow().setComplete(true);
                this.getPageWorkflow().save();
            } else {
                this.getPageWorkflow().routingComplete();
            }
        }
    }

    public Reviewer reviewerForUser(ConfluenceUser user) {
        Reviewer reviewer = this.getApprovalStep().reviewerForUser(user);
        if (reviewer == null && this.isPublishingWorkflowEditor()) {
            reviewer = (Reviewer)((Object)new BrikitList(this.getReviewers()).first());
        }
        return reviewer;
    }

    public Reviewer reviewerForCurrentUser() {
        return this.reviewerForUser(Confluence.getConfluenceUser());
    }

    public void reviewerRejected(LocalNotificationService notificationService, PageReviewer pageReviewer) {
        this.getPageWorkflow().stepBackward(notificationService, true);
    }

    public void reviewerUndidApprove(LocalNotificationService notificationService, PageReviewer pageReviewer) {
        if (!this.getPageWorkflow().isComplete() && !this.getPageWorkflow().isCurrentStep(this)) {
            this.getPageWorkflow().stepBackward(notificationService, false);
        }
    }

    public void reviewerUndidReject(PageReviewer pageReviewer) {
        if (!this.getPageWorkflow().isCurrentStep(this)) {
            this.getPageWorkflow().getCurrentPageApprovalStep().removeResets();
            this.getPageWorkflow().stepForward();
        }
    }
}

