(function ($) {
	//
	// Initializes control widges in workflow admin panels (space and global) and handles the workflow management calls.
	// Workflow definition and editing calls are delegated to the appropriate working dialogs.
	//
	ContentFlowManageWorkflowsPanel = function () {
		var self = this;		
		self.initialize();
	};
	
	Object.assign(ContentFlowManageWorkflowsPanel.prototype, {
		
		clearSpaceAutomatic: function (event) {
			event.preventDefault();
			
			var data = {
				spaceKey: ContentFlow.spaceKey
			}
			var templateName = $(this).closest("ul").data("name");
			var confirmTitle   = ContentFlow.getText("com.brikit.contentflow.clear.automatic.workflow.template.title");
			var confirmMessage = ContentFlow.getText("com.brikit.contentflow.clear.automatic.workflow.template");
			ContentFlow.Dialog2.confirm(confirmMessage, {title: confirmTitle}, function (dialog) {
	            jQuery.ajax({
	                url: ContentFlow.contextPath + "/plugins/contentflow/clearspaceautomatictemplate.action",
	                data: data,
	                success: function(response) {
	                },
	                error: function (xhRequest, textStatus, errorThrown) {
	                    ContentFlow.alertError("An error occurred while clearing the automatic template.", errorThrown);
						dialog.enable();
	                },
					complete: function () {
						dialog.hide();
						location.reload(true);
					}
	            });
			});

            return false;
		},
		
		
		deleteSpaceTemplate: function (event, target) {
			event.preventDefault();
			
			var $container = $(target).closest("ul");
            
            if ($container.data("active-page-count") > 0) {
                ContentFlow.Dialog2.alert(ContentFlow.getText("com.brikit.contentflow.workflow.in.use.with.help"), 
                    {title: ContentFlow.getText("com.brikit.contentflow.workflow.in.use"), size: "medium"});
                return;
            }

			var data = {
				spaceKey: ContentFlow.spaceKey,
				workflowId: $container.data("workflow-id")
			}

			var templateName = $container.data("name");
			var confirmTitle   = ContentFlow.getText("com.brikit.contentflow.delete.workflow.template.title");
			var confirmMessage = ContentFlow.getText("com.brikit.contentflow.delete.workflow.template", [templateName]);
			
			ContentFlow.Dialog2.confirm(confirmMessage, {title: confirmTitle}, function (dialog) {
	            jQuery.ajax({
	                url: ContentFlow.contextPath + "/plugins/contentflow/deletespacetemplate.action",
	                data: data,
	                success: function(response) {
						var result = $($.parseXML(response));
						// Is response an error?  If so alert user
						if (result.find(".errorMessage").length) {
							ContentFlow.alertError(result.text(), "");
						}
	                },
	                error: function (xhRequest, textStatus, errorThrown) {
						ContentFlow.alertError("An error occurred while deleting the template.", errorThrown);
						dialog.enable();
	                },
					complete: function () {
						dialog.hide();
						location.reload(true);
					}
	            });
			});

            return false;
		},
	
		editWorkflow: function(event) {
			// event target is the "Edit" option in Actions menu
			// If it's a multi-space workflow, prohibit editing in space admin (permit in global admin only)
			if (!$(event.target).closest("ul").hasClass("space-only") &&  ContentFlow.spaceKey) {
				alert(ContentFlow.getText("com.brikit.contentflow.no.edit.global.workflow"));
				return;
			}
			
			this.showEditDialog(event);
		},
		
		
		initialize: function() {
			var self = this;
			
			$(".create-workflow").click(this.showEditDialog.bind(this));
			$(".edit-template-button").click(this.editWorkflow.bind(this));	
			
			$("#enable-workflows-checkbox").click(this.toggleEnableWorkflows.bind(this));
			$("#disable-workflows-checkbox").click(this.toggleDisableWorkflows.bind(this));
			
			$(".make-automatic-template-button").click(function (e) { self.makeSpaceAutomatic(e, this); });
			$(".clear-automatic-template-button").click(this.clearSpaceAutomatic.bind(this));
			$(".delete-space-template-button").click(function (e) { self.deleteSpaceTemplate(e, this); });	

			$(".reviewer-entry.editor .reviewer-name").tooltip({aria:true});
			// we're re-using the Confluence userLogoLink, but don't want its click-thru behavior:
			$("#content-flow-templates").on("click.brikit-content-flow", 	".reviewer-list .userLogoLink", 	function () { return false; })
		    
		},


		makeSpaceAutomatic: function (event, target) {
			event.preventDefault();
			var $container = $(target).closest("ul");
			
			var data = {
				spaceKey: ContentFlow.spaceKey,
				workflowId: $container.data("workflow-id")
			}
			var templateName = $container.data("name");
			var confirmTitle   = ContentFlow.getText("com.brikit.contentflow.make.automatic.workflow.template.title");
			var confirmMessage = ContentFlow.getText("com.brikit.contentflow.make.automatic.workflow.template", [templateName]);
			ContentFlow.Dialog2.confirm(confirmMessage, {title: confirmTitle}, function (dialog) {
	            jQuery.ajax({
	                url: ContentFlow.contextPath + "/plugins/contentflow/spaceautomatictemplate.action",
	                data: data,
	                success: function(response) {
	                },
	                error: function (xhRequest, textStatus, errorThrown) {
	                    ContentFlow.alertError("An error occurred while setting the automatic template.", errorThrown);
						dialog.enable();
	                },
					complete: function () {
						dialog.hide();
						location.reload(true);
					}
	            });
			});

            return false;
		},		
			
		showEditDialog: function(e) {
			e.preventDefault();
			var editDialog = new ContentFlowEditDialog(e);
			editDialog.show();
		},
		
		toggleDisableWorkflows: function (event) {
			event.preventDefault();
			
			var disableWorkflows = $("#disable-workflows-checkbox:checked").length;

			var confirmTitle   = ContentFlow.getText(disableWorkflows ? "com.brikit.contentflow.disable.workflows" : "com.brikit.contentflow.enable.workflows");
			var confirmMessage = ContentFlow.getText(disableWorkflows ? "com.brikit.contentflow.disable.workflows.confirmation" : "com.brikit.contentflow.enable.workflows.confirmation");
			var action = disableWorkflows ? "disableworkflows.action" : "cleardisableworkflows.action";

			this.toggleWorkflowEnablement(confirmTitle, confirmMessage, action);
		},
				
		toggleEnableWorkflows: function (event) {
			event.preventDefault();
			
			var enableWorkflows = $("#enable-workflows-checkbox:checked").length;

			var confirmTitle   = ContentFlow.getText(enableWorkflows ? "com.brikit.contentflow.enable.workflows" : "com.brikit.contentflow.disable.workflows");
			var confirmMessage = ContentFlow.getText(enableWorkflows ? "com.brikit.contentflow.enable.workflows.confirmation" : "com.brikit.contentflow.disable.workflows.confirmation");
			var action = enableWorkflows ? "enableworkflows.action" : "clearenableworkflows.action";
            
			this.toggleWorkflowEnablement(confirmTitle, confirmMessage, action);
		},
		
		toggleWorkflowEnablement: function (confirmTitle, confirmMessage, action) {
			event.preventDefault();
			
			var data = {
				spaceKey: ContentFlow.spaceKey,
			}
			ContentFlow.Dialog2.confirm(confirmMessage, {title: confirmTitle}, function (dialog) {
	            jQuery.ajax({
	                url: ContentFlow.contextPath + "/plugins/contentflow/" + action,
	                data: data,
	                success: function(response) {
	                },
	                error: function (xhRequest, textStatus, errorThrown) {
	                    ContentFlow.alertError("An error occurred while changing workflows enablement.", errorThrown);
						dialog.enable();
	                },
					complete: function () {
						dialog.hide();
						location.reload(true);
					}
	            });
			});

            return false;
		}
				
	});

	ContentFlow.toInit(function ($) {
		if ($("#content-flow-templates, #space-workflows-enablement").length) new ContentFlowManageWorkflowsPanel();
	}
);

})(jQuery);
