/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ContentFlowUtils {
    public static final String PERMISSION_TYPE = "type";
    public static final String PERMISSION_USER_KEY = "user";
    public static final String PERMISSION_GROUP_NAME = "group";
    public static final String NOTIFICATION_KEY = "com.brikit.contentflow.notification";

    public static void addPageToIndexQueue(AbstractPage abstractPage) {
        Confluence.addAbstractPageToIndexQueueForUpdate((AbstractPage)abstractPage, (boolean)false);
    }

    protected static String contentPermissionsJSON(Collection<ContentPermission> permissions) {
        JsonArray permissionsJSON = new JsonArray();
        for (ContentPermission permission : permissions) {
            JsonObject permissionJSON = new JsonObject();
            permissionJSON.addProperty(PERMISSION_TYPE, permission.getType());
            permissionJSON.addProperty(PERMISSION_USER_KEY, permission.isUserPermission() ? permission.getUserSubject().getKey().getStringValue() : null);
            permissionJSON.addProperty(PERMISSION_GROUP_NAME, permission.isGroupPermission() ? permission.getGroupName() : null);
            permissionsJSON.add((JsonElement)permissionJSON);
        }
        return permissionsJSON.toString();
    }

    public static void setEditPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        if (permissionSet == null) {
            permissionSet = ContentFlowUtils.getOpenEditPermissions(abstractPage);
        }
        Confluence.setContentPermissions((Collection)permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)abstractPage, (String)"Edit");
    }

    public static void setViewPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        if (permissionSet == null) {
            permissionSet = ContentFlowUtils.getOpenViewPermissions(abstractPage);
        }
        Confluence.setContentPermissions((Collection)permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)abstractPage, (String)"View");
    }

    public static Collection<ContentPermission> getContentPermissionsFromJSON(String permissionsjSON) {
        HashSet<ContentPermission> contentPermissions = new HashSet<ContentPermission>();
        try {
            JsonParser parser = new JsonParser();
            JsonArray permissionsArray = parser.parse(permissionsjSON).getAsJsonArray();
            for (JsonElement next : permissionsArray) {
                ContentPermission permission;
                JsonObject json = next.getAsJsonObject();
                String type = json.get(PERMISSION_TYPE).getAsString();
                String userKey = json.get(PERMISSION_USER_KEY).getAsString();
                String groupName = json.get(PERMISSION_GROUP_NAME).getAsString();
                if (BrikitString.isSet((String)userKey)) {
                    ConfluenceUser user = Confluence.getConfluenceUserByUserKey((String)userKey);
                    permission = ContentPermission.createUserPermission((String)type, (ConfluenceUser)user);
                } else {
                    permission = ContentPermission.createGroupPermission((String)type, (String)groupName);
                }
                contentPermissions.add(permission);
            }
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Failed to parse permissions from string: " + permissionsjSON), (Exception)ex);
        }
        return contentPermissions;
    }

    public static ContentPermissionSet getOpenEditPermissions(AbstractPage abstractPage) {
        return new ContentPermissionSet("Edit", (ContentEntityObject)abstractPage);
    }

    public static ContentPermissionSet getOpenViewPermissions(AbstractPage abstractPage) {
        return new ContentPermissionSet("View", (ContentEntityObject)abstractPage);
    }

    public static boolean jsonHasKeyNotNull(JsonObject json, String key) {
        return json.has(key) && BrikitString.isSet((String)json.get(key).getAsString());
    }

    protected static String toJSON(ContentPermissionSet permissionSet) {
        return ContentFlowUtils.contentPermissionsJSON(permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST));
    }
}

