/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AttachmentUploadRequest;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentBlueprintAo;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.brikit.blueprintmaker.actions.BlueprintMakerActionSupport;
import com.brikit.blueprintmaker.model.BlueprintPage;
import com.brikit.blueprintmaker.model.CopyPageBlueprint;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.ao.Query;

public class CreateFromBlueprintAction
extends BlueprintMakerActionSupport {
    protected static final String SPACE_BLUEPRINT_TYPE = "space";
    protected static final String REGENERATE_PAGE = "regenerate";
    protected String selectedBlueprint;
    protected String originalPageTemplateId;
    protected String blueprintType;
    protected String blueprintName;
    protected String spaceName;
    protected String spaceKey;
    protected String spaceDescription;
    protected String pageTitle;
    protected String pageLabels;
    protected String values;
    protected String currentSpaceKey;
    protected String currentPageId;
    protected String destinationPageTitle;
    protected String createNewPage;
    protected BlueprintManager blueprintManager;
    protected ContentBlueprintManager contentBlueprintManager;
    protected ActiveObjects activeObjects;

    protected String createFromPageBlueprint() {
        try {
            AbstractPage newPage = null;
            newPage = CopyPageBlueprint.isCopyPage(this.getBlueprintName()) ? BlueprintPage.copyPage((AbstractPage)this.getCurrentPage(), this.getCurrentSpaceKey(), this.getPageTitle(), this.getDestinationPage()) : (this.shouldRegeneratePage() ? BlueprintPage.regeneratePageFromBlueprint(this.getBlueprintName(), this.getCurrentPageId(), this.getPageTitle(), this.getValues(), this.getFileResources(), this.getPageLabels()) : BlueprintPage.createFromPageBlueprint(this.getBlueprintName(), this.getCurrentSpaceKey(), this.getPageTitle(), this.getDestinationPage(), this.getValues(), this.getFileResources(), this.getPageLabels()));
            this.setResult(Confluence.getPageURL(newPage));
            return "success";
        }
        catch (Exception ex) {
            BrikitLog.logDebug("Failed to create page from blueprint.", ex);
            this.addActionError(ex.getMessage());
            return "error";
        }
    }

    protected String createFromSpaceBlueprint() {
        try {
            Space newSpace = SpaceBlueprint.createFromSpaceBlueprint(this.getBlueprintName(), this.getCurrentSpaceKey(), this.getSpaceName(), this.getSpaceKey(), this.getSpaceDescription(), this.getValues(), this.getFileResources(), this.getBlueprintManager(), this.getContentBlueprintManager());
            this.setResult(Confluence.getPageURL((AbstractPage)Confluence.getSpaceHomePage(newSpace)));
            return "success";
        }
        catch (Exception ex) {
            BrikitLog.logError("Failed to create space from blueprint.", ex);
            this.addActionError(BrikitString.isSet(ex.getMessage()) ? ex.getMessage() : "Failed to create space from blueprint: " + ex.toString());
            return "error";
        }
    }

    @Override
    public String execute() throws Exception {
        if (this.isLiveBlueprint()) {
            return this.updateLiveBlueprint();
        }
        return this.isSpaceBlueprint() ? this.createFromSpaceBlueprint() : this.createFromPageBlueprint();
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public BlueprintManager getBlueprintManager() {
        return this.blueprintManager;
    }

    public String getBlueprintName() {
        return this.blueprintName;
    }

    public String getBlueprintType() {
        return this.blueprintType;
    }

    public ContentBlueprintManager getContentBlueprintManager() {
        return this.contentBlueprintManager;
    }

    protected List<ContentBlueprintAo> getContentBlueprints(final String spaceKey) {
        return (List)this.getActiveObjects().executeInTransaction((TransactionCallback)new TransactionCallback<List<ContentBlueprintAo>>(){

            public List<ContentBlueprintAo> doInTransaction() {
                Query query = Query.select();
                query.setWhereClause("SPACE_KEY = ? OR SPACE_KEY IS NULL");
                query.setWhereParams(new Object[]{spaceKey});
                query.order("ID");
                List<ContentBlueprintAo> aos = Arrays.asList((ContentBlueprintAo[])CreateFromBlueprintAction.this.activeObjects.find(ContentBlueprintAo.class, query));
                return aos;
            }
        });
    }

    public String getCreateNewPage() {
        return this.createNewPage;
    }

    public Page getCurrentPage() {
        AbstractPage currentPage = Confluence.getPageOrBlogPost(this.getCurrentPageId());
        return currentPage instanceof Page ? (Page)currentPage : Confluence.getSpaceHomePage(currentPage);
    }

    public String getCurrentPageId() {
        return this.currentPageId;
    }

    public String getCurrentSpaceKey() {
        return this.currentSpaceKey;
    }

    public Page getDestinationPage() {
        if (this.shouldRegeneratePage() || !BrikitString.isSet(this.getDestinationPageTitle())) {
            return this.getCurrentPage();
        }
        String markupTitle = this.getDestinationPageTitle();
        int index = markupTitle.indexOf(":");
        String spaceKey = index == -1 ? this.getCurrentSpaceKey() : markupTitle.substring(0, index);
        String title = index == -1 ? markupTitle : markupTitle.substring(index + 1);
        return Confluence.getPage(spaceKey, title);
    }

    public String getDestinationPageTitle() {
        return this.destinationPageTitle;
    }

    public Map<String, AttachmentResource> getFileResources() {
        HashMap<String, AttachmentResource> resources = new HashMap<String, AttachmentResource>();
        if (this.getMultiPartRequest() != null) {
            AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(this.getMultiPartRequest());
            for (AttachmentResource resource : uploadRequest.getResources()) {
                resources.put(resource.getFilename(), resource);
            }
        }
        return resources;
    }

    public AbstractPage getOriginalPageTemplate() {
        return Confluence.getPageOrBlogPost(this.getOriginalPageTemplateId());
    }

    public String getOriginalPageTemplateId() {
        return this.originalPageTemplateId;
    }

    protected List<String> getPageLabels() {
        return BrikitString.splitCommaSeparated(this.getPageLabelsString());
    }

    public String getPageLabelsString() {
        return this.pageLabels;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getSelectedBlueprint() {
        return this.selectedBlueprint;
    }

    public String getSpaceDescription() {
        return this.spaceDescription;
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getValues() {
        return this.values;
    }

    public boolean isSpaceBlueprint() {
        return SPACE_BLUEPRINT_TYPE.equalsIgnoreCase(this.getBlueprintType());
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void setBlueprintManager(BlueprintManager blueprintManager) {
        this.blueprintManager = blueprintManager;
    }

    public void setContentBlueprintManager(ContentBlueprintManager contentBlueprintManager) {
        this.contentBlueprintManager = contentBlueprintManager;
    }

    public void setCreateNewPage(String createNewPage) {
        this.createNewPage = createNewPage;
    }

    public void setCurrentPageId(String currentPageId) {
        this.currentPageId = currentPageId;
    }

    public void setCurrentSpaceKey(String currentSpaceKey) {
        this.currentSpaceKey = currentSpaceKey;
    }

    public void setDestinationPageTitle(String destinationPageTitle) {
        this.destinationPageTitle = destinationPageTitle;
    }

    public void setOriginalPageTemplateId(String originalPageTemplateId) {
        this.originalPageTemplateId = originalPageTemplateId;
    }

    public void setPageLabels(String pageLabels) {
        this.pageLabels = pageLabels;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public void setSelectedBlueprint(String selectedBlueprint) {
        this.selectedBlueprint = selectedBlueprint;
        if (!BrikitString.isSet(selectedBlueprint)) {
            return;
        }
        int split = selectedBlueprint.indexOf(":");
        if (split == -1) {
            this.blueprintName = selectedBlueprint;
            this.blueprintType = SPACE_BLUEPRINT_TYPE;
        } else {
            this.blueprintType = selectedBlueprint.substring(0, split);
            this.blueprintName = selectedBlueprint.substring(split + 1);
        }
    }

    public void setSpaceDescription(String spaceDescription) {
        this.spaceDescription = spaceDescription;
    }

    @Override
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public boolean shouldRegeneratePage() {
        return REGENERATE_PAGE.equalsIgnoreCase(this.getCreateNewPage());
    }

    protected String updateLiveBlueprint() {
        try {
            AbstractPage newPage = BlueprintPage.updateLiveBlueprint(this.getBlueprintName(), this.getCurrentPageId(), this.getMacroId(), this.getValues(), this.getFileResources());
            this.setResult(Confluence.getPageURL(newPage));
            return "success";
        }
        catch (Exception ex) {
            BrikitLog.logDebug("Failed to create page from blueprint.", ex);
            this.addActionError(ex.getMessage());
            return "error";
        }
    }
}

