/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.v2.RenderMode;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitProperties;
import com.brikit.core.util.BrikitString;
import java.util.Map;

public class LiveBlueprintMacro
extends BrikitBaseMacro {
    public static final String TEMPLATE_NAME = "blueprint-maker/templates/macros/live-blueprint.vm";
    public static final String BLUEPRINT_NAME_PARAM = "blueprint-name";
    public static final String PAGE_PARAM = "page";
    public static final String RENDER_IN_BLUEPRINT_CONTEXT_PARAM = "render-in-blueprint-context";
    public static final String BLUEPRINT_PAGE = "blueprint-page";
    public static final String BLUEPRINT_PROPERTIES = "blueprint-properties";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        PageBlueprint pageBlueprint = BlueprintDefinitions.getPageBlueprint(macroContext.stringValue(BLUEPRINT_NAME_PARAM));
        Page blueprintPage = pageBlueprint == null ? macroContext.pageFromValue(PAGE_PARAM, null) : pageBlueprint.getConfluencePage();
        macroContext.velocityContextAdd(BLUEPRINT_PAGE, blueprintPage);
        if (blueprintPage == null) {
            throw new MacroExecutionException("Blueprint page not found.");
        }
        boolean renderInContext = macroContext.booleanValue(RENDER_IN_BLUEPRINT_CONTEXT_PARAM);
        String blueprintBody = Confluence.getBodyAsString((ContentEntityObject)blueprintPage);
        BrikitProperties properties = BrikitString.getProperties(body);
        macroContext.velocityContextAdd(BLUEPRINT_PROPERTIES, properties.toJSON());
        for (Object property : properties.keySet()) {
            String key = (String)property;
            String value = properties.getProperty(key);
            blueprintBody = blueprintBody.replaceAll("\\[\\[" + key + "]]", value);
        }
        Page renderContext = renderInContext ? blueprintPage : macroContext.getPage();
        macroContext.velocityContextAdd("body", Confluence.render(blueprintBody, (AbstractPage)renderContext));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }
}

