/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.draw;

import com.brikit.core.util.BrikitString;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class IconMaker {
    public static final String TRANSPARENT_COLOR = "transparent";

    protected static Color color(String hexRGB) {
        if (TRANSPARENT_COLOR.equals(hexRGB)) {
            return new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (hexRGB.indexOf("#") == 0) {
            hexRGB = hexRGB.substring(1);
        }
        int r = Integer.parseInt(hexRGB.substring(0, 2), 16);
        int g = Integer.parseInt(hexRGB.substring(2, 4), 16);
        int b = Integer.parseInt(hexRGB.substring(4, 6), 16);
        return new Color(r, g, b);
    }

    public static BufferedImage renderIcon(BufferedImage sourceIcon, String imageRGB, int iconSize, int imageSize, String fieldRGB, int fieldSize, int fieldRadius, String borderRGB, float borderWidth) {
        BufferedImage outputImage = new BufferedImage(iconSize, iconSize, 2);
        Graphics2D graphics = outputImage.createGraphics();
        BufferedImage scaledImage = IconMaker.scaleBufferedImage(sourceIcon, imageSize);
        float fieldOffset = (iconSize - imageSize) / 2;
        IconMaker.drawField(graphics, fieldOffset, imageSize, imageRGB, 0, 0.0f);
        IconMaker.drawImage(scaledImage, graphics, iconSize, imageSize, 6);
        graphics.dispose();
        if (fieldSize > 0 && BrikitString.isSet((String)fieldRGB) || borderWidth > 0.0f && BrikitString.isSet((String)borderRGB)) {
            BufferedImage drawnImage = outputImage;
            outputImage = new BufferedImage(iconSize, iconSize, 2);
            graphics = outputImage.createGraphics();
            fieldOffset = (float)(iconSize - fieldSize) / 2.0f;
            IconMaker.drawField(graphics, fieldOffset, fieldSize, fieldRGB, fieldRadius, 0.0f);
            if (borderWidth > 0.0f && BrikitString.isSet((String)borderRGB)) {
                fieldSize = (int)((float)fieldSize - borderWidth);
                fieldOffset = (float)(iconSize - fieldSize) / 2.0f;
                IconMaker.drawField(graphics, fieldOffset, fieldSize, borderRGB, fieldRadius, borderWidth);
            }
            IconMaker.drawImage(drawnImage, graphics, iconSize, iconSize, 3);
            graphics.dispose();
        }
        return outputImage;
    }

    public static void drawField(Graphics2D graphics, float offset, int fieldSize, String colorRGB, int fieldRadius, float borderWidth) {
        if (!BrikitString.isSet((String)colorRGB)) {
            return;
        }
        Color fieldColor = IconMaker.color(colorRGB);
        graphics.setColor(fieldColor);
        if (fieldRadius > 0) {
            RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHints(renderHints);
        }
        RoundRectangle2D.Float roundedRectangle = new RoundRectangle2D.Float(offset, offset, fieldSize, fieldSize, fieldRadius, fieldRadius);
        if (borderWidth > 0.0f) {
            graphics.setStroke(new BasicStroke(borderWidth));
            graphics.draw(roundedRectangle);
        } else {
            graphics.fill(roundedRectangle);
        }
    }

    public static void drawImage(BufferedImage image, Graphics2D graphics, int iconSize, int imageSize, int composite) {
        int dx2;
        int dx1;
        int dy1 = dx1 = (iconSize - imageSize) / 2;
        int dy2 = dx2 = dx1 + imageSize;
        int sx1 = 0;
        int sy1 = 0;
        int sx2 = sx1 + imageSize;
        int sy2 = sy1 + imageSize;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(composite, 1.0f);
        graphics.setComposite(alphaComposite);
        graphics.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public static BufferedImage scaleBufferedImage(BufferedImage image, int imageSize) {
        Image scaledImage = image.getScaledInstance(imageSize, imageSize, 4);
        BufferedImage scaledBufferedImage = new BufferedImage(imageSize, imageSize, 2);
        Graphics2D graphics = scaledBufferedImage.createGraphics();
        graphics.drawImage(scaledImage, 0, 0, null);
        graphics.dispose();
        return scaledBufferedImage;
    }

    public static boolean isValid(String color, int opacity) {
        return BrikitString.isSet((String)color) && opacity >= 0 && opacity <= 100;
    }
}

