(function ($) {
	
	ThemePress.MobileSearch = {

		searchCache: {},

		composeSearchResults: function (data) {
			ThemePress.MobileSearch.mobileResultsSpinner().hide();

			var $ol = $("<ol>");
			$.each(data.results, function (i, r) {
				var url = ThemePress.contextPath + r._links.webui;
				var $title = $("<span>").attr("title", r.title + " (" + r.space.name + ")").text(r.title);
				var $titleLink = $("<a>").addClass("content-type-" + r.type).attr("href", url).append($title);
				var $spaceLink = $("<a>").addClass("space-name").attr("href", url).append(r.space.name);
				var $li = $("<li>").addClass("with-space-name").append($titleLink).append($spaceLink);
				$ol.append($li);
			});
			
			if (!$ol.find("li").length) {
				var $li = $("<li>").addClass("no-results-found").append($("<em>").text("No results found."));
				$ol.append($li);
			}

			ThemePress.MobileSearch.searchCache[ThemePress.MobileSearch.searchText] = $ol;
			
			ThemePress.MobileSearch.searchInProgress = false;
			
			ThemePress.MobileSearch.updateSearchResults();
		},

		defaultSearchFieldChanged: function(event) {
			clearTimeout(ThemePress.MobileSearch.searchTimeout);
			ThemePress.MobileSearch.searchTimeout = setTimeout(ThemePress.MobileSearch.doSearch, 300);
		},
		
		doSearch: function () {
			if (ThemePress.MobileSearch.searchInProgress) return;

			var $defaultSearch = ThemePress.Mobile.quickSearchField();
			var searchText = $defaultSearch.val();
			
			// For short, but not empty searches, wait for something more to happen
			if (searchText.length && searchText.length < 3) return;

			ThemePress.MobileSearch.searchText = searchText;
			if (!searchText || ThemePress.MobileSearch.searchCache[searchText]) return ThemePress.MobileSearch.updateSearchResults();

			ThemePress.MobileSearch.searchInProgress = true;
			ThemePress.MobileSearch.mobileResultsSpinner().show();
			var data = {
			    cql: 'type in ("page", "blogpost") AND space.key != "themepressdefault" AND text ~ "' + ThemePress.MobileSearch.searchText + '"',
				expand: "space,metadata.labels"
			};

			$.ajax({
			    url: ThemePress.contextPath + "/rest/api/content/search",
			    data : data,
			    type: "GET",
			    success: ThemePress.MobileSearch.composeSearchResults, 
				error: function(x,s,t) {console.log(x,s,t);},
			    dataType: "json"
			});
		},
		
		initialize: function () {
			// Replace Confluence's built-in quick search field with a new input field
			var $defaultSearch = ThemePress.Mobile.quickSearchField();
			if (!$defaultSearch.length) return;
			
            var $brikitMobileSearch = $("#brikit-mobile-search").empty().append(ThemePress.Mobile.quickSearch());
			$brikitMobileSearch.html($brikitMobileSearch.html()); // Replace to disconnect event listeners
			
			var $quickSearch = $("#search-ui, #quick-search").first().attr("id", "quick-search").addClass("brikit-replacement");
			ThemePress.Mobile.quickSearchField().on("keyup", ThemePress.MobileSearch.defaultSearchFieldChanged);

			// Build a drop-down results container
			var $dropDown = $("<div>").attr("id", "brikit-quick-search-mobile-results");
			$quickSearch.append($dropDown);
		},

		mobileResults: function () {
			return $("#brikit-quick-search-mobile-results");
		},
		
		mobileResultsSpinner: function () {
			return $("#quick-search.brikit-replacement .aui-spinner");
		},
		
		updateSearchResults: function () {
			var $results = ThemePress.MobileSearch.mobileResults().empty();
			if (ThemePress.MobileSearch.searchText) $results.append(ThemePress.MobileSearch.searchCache[ThemePress.MobileSearch.searchText]);
			$results.showIf(ThemePress.MobileSearch.searchText);
		},
		
	};

})(jQuery);

