/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.icons;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.draw.IconMaker;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.util.ThemePress;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class IconLibrary {
    public static final String ICON_SIZE_SMALL = "small";
    public static final String ICON_SIZE_MEDIUM = "medium";
    public static final String ICON_SIZE_LARGE = "large";
    public static final String PLACEHOLDER_ICON_NAME = "___unspecified_library_icon___";
    public static final String DEFAULT_IMAGE_COLOR = "primaryColor";
    public static final String DEFAULT_FIELD_COLOR = "transparent";
    public static final String DEFAULT_BORDER_COLOR = "transparent";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearIconCache(String iconName) throws IOException {
        File cache = IconLibrary.getIconStorageFolder(iconName);
        String string = iconName;
        synchronized (string) {
            if (cache.exists()) {
                BrikitFile.removeFile((File)cache);
            }
        }
    }

    protected static void generateIcon(File iconFile, String iconName, String imageRGB, int iconSize, int imageSize, String fieldRGB, int fieldSize, int fieldRadius, String borderRGB, float borderWidth) throws IOException {
        BufferedImage iconImage = PLACEHOLDER_ICON_NAME.equals(iconName) ? ImageIO.read(ThemeResourceServlet.themeResource((String)"/images/library-icon-placeholder.png")) : IconLibrary.readIconLibraryAttachment(iconName);
        BufferedImage outputImage = IconMaker.renderIcon(iconImage, imageRGB, iconSize, imageSize, fieldRGB, fieldSize, fieldRadius, borderRGB, borderWidth);
        IconLibrary.save(outputImage, iconFile);
    }

    public static String defaultIconSize(String iconName) {
        return PLACEHOLDER_ICON_NAME.equals(iconName) ? ICON_SIZE_SMALL : ICON_SIZE_MEDIUM;
    }

    public static String defaultIconUrl(String themeName) {
        String url = Confluence.getContextPath() + "/plugins/servlet/themepress" + "/brikitservlet/library/icons/themed/" + themeName + "/";
        String firstLibrary = (String)IconLibrary.getIconLibraryAttachmentNames().first();
        url = url + (BrikitString.isSet((String)firstLibrary) ? firstLibrary : PLACEHOLDER_ICON_NAME);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getIcon(String themeName, String iconName, String imageColorKey, int iconSize, int imageSize, String fieldColorKey, int fieldSize, int fieldRadius, String borderColorKey, float borderWidth) throws IOException {
        ThemeProperties themeProperties = ThemeProperties.getThemeProperties(themeName);
        String imageColor = themeProperties.getColorValue(imageColorKey);
        String fieldColor = BrikitString.isSet((String)fieldColorKey) ? themeProperties.getColorValue(fieldColorKey) : "";
        String borderColor = BrikitString.isSet((String)borderColorKey) ? themeProperties.getColorValue(borderColorKey) : "";
        File iconFile = IconLibrary.getIconPath(iconName, imageColor, iconSize, imageSize, fieldColor, fieldSize, fieldRadius, borderColor, borderWidth);
        if (!Confluence.isAnonymousUser()) {
            String string = iconName;
            synchronized (string) {
                if (!iconFile.exists()) {
                    IconLibrary.generateIcon(iconFile, iconName, imageColor, iconSize, imageSize, fieldColor, fieldSize, fieldRadius, borderColor, borderWidth);
                }
            }
        }
        return iconFile;
    }

    public static File getIconStorageFolder(String iconName) throws IOException {
        File brikitFolder = BrikitFile.getConfluenceTempDirectoryPath((String)"brikit");
        File imageFolder = new File(brikitFolder, "icons");
        File iconFolder = new File(imageFolder, iconName);
        BrikitFile.ensurePathExists((File)iconFolder);
        return iconFolder;
    }

    public static String getIconLibraryPageTitle() {
        return ".brikit.icons";
    }

    public static Attachment getIconLibraryAttachment(String iconName) {
        return Confluence.getImageAttachment((AbstractPage)IconLibrary.getIconLibraryPage(), (String)iconName);
    }

    public static BrikitList<String> getIconLibraryAttachmentNames() {
        BrikitList names = new BrikitList();
        for (Attachment attachment : IconLibrary.getIconLibraryAttachments()) {
            names.add((Object)BrikitFile.nameWithoutExtension((String)attachment.getFileName()));
        }
        return names;
    }

    public static List<Attachment> getIconLibraryAttachments() {
        return Confluence.getImageAttachments((AbstractPage)IconLibrary.getIconLibraryPage());
    }

    public static Page getIconLibraryPage() {
        return ThemePress.getArchitectPage(IconLibrary.getIconLibraryPageTitle());
    }

    public static File getIconPath(String iconName, String imageColor, int iconSize, int imageSize, String fieldColor, int fieldSize, int fieldRadius, String borderColor, float borderWidth) throws IOException {
        BrikitList bits = new BrikitList();
        bits.add((Object)iconName);
        bits.add((Object)(imageColor.startsWith("#") ? imageColor.substring(1) : imageColor));
        bits.add((Object)iconSize);
        bits.add((Object)imageSize);
        bits.add((Object)(fieldColor.startsWith("#") ? fieldColor.substring(1) : fieldColor));
        bits.add((Object)fieldSize);
        bits.add((Object)fieldRadius);
        bits.add((Object)(borderColor.startsWith("#") ? borderColor.substring(1) : borderColor));
        bits.add((Object)Float.valueOf(borderWidth));
        return new File(IconLibrary.getIconStorageFolder(iconName), bits.join("_") + ".png");
    }

    public static BufferedImage readIconLibraryAttachment(String iconName) {
        Attachment iconFile = IconLibrary.getIconLibraryAttachment(iconName);
        return iconFile == null ? null : Confluence.readImageAttachment((Attachment)iconFile);
    }

    public static void save(BufferedImage image, File file) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ex) {
            BrikitLog.logError((String)("Fail to write image file: " + file.getPath()), (Exception)ex);
        }
    }
}

