(function ($) { 

	ThemePress.RecentlyViewedMacro = function (element) {
		this.element = $(element);
		this.initialize();
	};
	
	Object.assign(ThemePress.RecentlyViewedMacro.prototype, {

		initialize: function () {
			this.element.spin();
			
			// Don't do anything until the recently-viewed macro becomes visible (allows embedding in menus without the performance hit)
			this.checkVisible = setInterval(function () {
				if (this.element.filter(":visible").length) {
					clearInterval(this.checkVisible);
					this.load();
				}
			}.bind(this), 100);
		},
		
		load: function () {
			this.list = this.element.spinStop();

			var limit = parseInt(this.element.data("limit"));
			var showIcon = this.element.data("show-icon");
			var showSpace = this.element.data("show-space");
			
			var collection = new RY.PageCollection();
			var viewed = collection.fetch({
				success: function () {
					var results = JSON.parse(viewed.responseText);
					$.each(results, function (i, r) {
						if (i >= limit) return;
						var $a = $("<a>").attr("href", ThemePress.contextPath + r.url).addClass(r.type);
						if (showIcon) $a.append($("<span>").addClass("aui-icon content-type-" + r.type).text(r.type));
						$a.append($("<span>").addClass("title").text(r.title));
						if (showSpace) $a.append($("<span>").addClass("space").text(r.space));
							
						var $item = $("<li>")
							.append($("<span>").addClass("submenu-indent"))
							.append($("<span>").addClass("submenu-toggle"))
							.append($a);
						this.list.append($item);
					}.bind(this))
				}.bind(this)
			});
		}
		
	});
			
	ThemePress.toFinalize(function ($) {
		$(".recently-viewed-macro").each(function () { new ThemePress.RecentlyViewedMacro(this); });
	});

})(jQuery);
