(function ($) {
	
	TOCScroller = function (toc) {
		this.toc = $(toc);
		this.toc.data("toc", this);
		this.initialize();
	};
	
	var prototype = TOCScroller.prototype;

	prototype.adjustContainerHeight = function () {
		if (ThemePress.Browser.mobile) return;
		
		// Restore this if floating TOC is restored, and also need to make the container vertically scrollable
		// this.container.css("height", $(window).height() - this.topMargin - 8 + "px");
	};
	
	prototype.adjustedTopInDocument = function (tocHeading) {
		var $heading = $(this.hrefFromHeading(tocHeading));
		return ($heading.offset() ? $heading.offset().top : 0) - this.topMargin;
	};
    
	prototype.adjustTOC = ThemePress.slowDown(function () {
		var self = this;
		var threshhold = $(window).scrollTop();

		if (ThemePress.Browser.mobile) {
			var buttonThreshhold = threshhold + $(window).height();
			var $wikiContent = $(".wiki-content");
			var wikiContentBottom = $wikiContent.offset().top + $wikiContent.height();
			$(".responsive-toc-toggle").adjustClass("hit-bottom", buttonThreshhold > wikiContentBottom);
		}
		else {
			// var fixContainer = self.toc.closest(".brikit-content-column").offset().top - self.topMargin <= threshhold;
			// self.container.adjustClass("sticky-on", fixContainer);
			// self.container.css("top", fixContainer ? self.topMargin + "px" : "auto");
			// self.adjustContainerHeight();
		}
		
		var inView = false;
		
		self.headings.removeClass("current").each(function (i, tocHeading) {
			inView = inView || tocHeading;
			if (self.adjustedTopInDocument(tocHeading) > threshhold) return false;
			else inView = tocHeading;
		});

		$(inView).addClass("current");
		
	}, 100);
	
	prototype.composeTree = function () {
		var self = this;
		
		var want = ["h1"];
		var max = self.toc.data("max-heading");
		var excludeContent = self.toc.data("exclude");
		var h = 2;
		while (h <= max) {
			want.push("h" + h);
			h += 1;
		}
		want = want.join(",");
		
		var $topList = self.toc.find("ul");
		var columnSelector = "#main-content .brikit-content-column:not(.from-layout) .brikit-content-block:not(.main-column-addition):not(.from-layout)" +
				", #main-content.frames .brikit-content-block";
		$(columnSelector).addClass("join-toc");
		var count = 1;
		var $previousHeading = [];
		$(want, $(".join-toc")).each(function (i, heading) {
			var $heading = $(heading);
			if ($heading.attr("id") == "title-text" || excludeContent && $heading.closest(excludeContent).length) return;
			var text = $heading.text();
			var anchor = $heading.attr("id");
			anchor = anchor.replace(/\W/g, "_");
			$heading.attr("id", anchor);
			var tag = heading.tagName.toLowerCase();
			
			var $a = $("<a>").attr("href", "#" + anchor).text(text);
			var $p = $("<p>").addClass("toc-heading " + tag).data("tag", tag).append($a);
			var $container = [];
			if (!ThemePress.Browser.mobile && $previousHeading.length) {
				var previousTag = $previousHeading.data("tag");
				if (previousTag < tag) {
					$container = self.containerForHeading($previousHeading);
				}
				else if (previousTag == tag) {
					$container = self.containerForHeading($previousHeading.parent().closest(".toc-heading"));
				}
				else {
					while ($previousHeading.length && previousTag >= tag) {
						$previousHeading = $previousHeading.parent().closest(".toc-heading");
						previousTag = $previousHeading.data("tag");
					}
					$container = self.containerForHeading($previousHeading);
				}
				$previousHeading = self.headingForContainer($container);
				self.toggleForHeading($previousHeading).addClass("aui-icon aui-icon-small aui-iconfont-expanded");
				if ($container.length) $container.append($p);
				else self.toc.append($p);
			}
			else {
				self.toc.append($p);
			}
			$previousHeading = $p;

			if (!ThemePress.Browser.mobile) {
				var $closer = $("<span>").addClass("toc-collapse-toggle");
				$p.append($closer);
				
				$p.attr("data-toc-container", count).append($("<div>").addClass("toc-container").attr("id", "toc-container-" + count).data("toc-container", count));
				count += 1;
			}
		});
	};
	
	prototype.containerForHeading = function ($heading) {
		return $("#toc-container-" + $heading.data("toc-container"));
	};
	
	prototype.find = function (selector) {
		return selector ? $(selector, this.toc) : this.toc;
	};
	
	prototype.headingForContainer = function ($container) {
		return this.find(".toc-heading[data-toc-container=" + $container.data("toc-container") + "]");
	};
	
    prototype.hrefFromHeading = function (tocHeading) {
        return $("a", tocHeading).attr("href");
    },
	
	prototype.initialize = function () {
		var self = this;
		
		self.container = self.toc.closest(".brikit-content-block");
		self.container.width(self.container.outerWidth());
		
		if (ThemePress.Browser.mobile) {
			var $mobilePanel = self.toc.closest(".responsive-toc-container");
			self.container.remove();
			$(".brikit-canvas").append($mobilePanel);
			self.container = $mobilePanel;

			var $toggle = $mobilePanel.find(".responsive-toc-toggle");
			$(".wiki-content").append($toggle);
			$(".responsive-toc-container .closer, .responsive-toc-toggle").click(function (e) { self.toggleMobilePanel(e); });
		}
		else {
			self.adjustContainerHeight();
			self.container.addClass("sticky-for-toc");
			self.toc.on("click", ".toc-collapse-toggle", function (e) { self.toggleExpander(e, this); });
		}

		self.scrollingContainer().on("scroll", function (e) { self.adjustTOC(); });

		self.composeTree();
		
		self.headings = self.find("p");
		self.topMargin = self.toc.data("top-margin") || $(".brikit-header-backdrop").outerHeight(true);

		self.toc.on("click", "a", function (e) { e.preventDefault(); self.scrollToDocument($(this).closest("p")); });
		
		self.adjustTOC();	
	};

	prototype.scrollingContainer = function () {
		return $(document);
	};
	
	prototype.scrollToDocument = function (tocHeading) {
		var self = this;
		$("body").removeClass("show-mobile-toc");
		ThemePress.Mobile.updateScrollPrevention();
		$("body").addClass("disable-nav");
        
        // Update the browser URL without reloading the page
        let href = this.hrefFromHeading(tocHeading);
        window.history.pushState({"heading": href}, ThemePress.pageTitle, ThemePress.pageUrl.split("#")[0] + href);

		$("html, body").animate({scrollTop: self.adjustedTopInDocument(tocHeading) + 2}, 300, 
			function () {
				ThemePress.Mobile.hasScrolled(true, true);
				$("body").removeClass("disable-nav");
			}
		);
	};
	
	prototype.toggleExpander = function (e, target) {
		var $heading = $(target).closest(".toc-heading");
		this.containerForHeading($heading).slideToggle("fast");
		this.toggleForHeading($heading).toggleClass("aui-iconfont-expanded aui-iconfont-collapsed");
	};
	
	prototype.toggleForHeading = function ($heading) {
		return $heading.find(">.toc-collapse-toggle");
	};
	
	prototype.toggleMobilePanel = function (event) {
		$("body").toggleClass("show-mobile-toc");
		ThemePress.Mobile.updateScrollPrevention();
		this.adjustTOC();
	};
	
})(jQuery);

ThemePress.toFinalize(function ($) {
	$(".responsive-toc").each(function () { new TOCScroller(this); });
});
