/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class InstantPageCache {
    protected static final String PHONE_VIEW = "phone";
    protected static final String DESKTOP_VIEW = "desktop";
    protected static BrikitList<Locale> knownLocales;
    protected static Cache<String, String> cache;
    protected static CacheSettings cacheSettings;

    protected static String cacheKey(AbstractPage abstractPage, Locale locale, boolean isComalaPublished, boolean isPhone) {
        return InstantPageCache.cacheKey(abstractPage.getIdAsString(), locale, isComalaPublished, isPhone);
    }

    protected static String cacheKey(String pageIdAsString, Locale locale, boolean isComalaPublished, boolean isPhone) {
        return pageIdAsString + ":" + InstantPageCache.keyForLocale(locale) + ":" + InstantPageCache.keyForViewType(isComalaPublished) + ":" + InstantPageCache.keyForViewType(isPhone);
    }

    protected static String keyForViewType(boolean isPhone) {
        return isPhone ? PHONE_VIEW : DESKTOP_VIEW;
    }

    protected static String keyForLocale(Locale locale) {
        InstantPageCache.getKnownLocales().ensureContains((Object)locale);
        return locale.getDisplayLanguage();
    }

    public static synchronized String get(AbstractPage abstractPage, Locale locale, boolean isComalaPublished, boolean isPhone) {
        return (String)InstantPageCache.getCache().get((Object)InstantPageCache.cacheKey(abstractPage, locale, isComalaPublished, isPhone));
    }

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache(Confluence.getText((String)"com.brikit.themepress.instant.page.cache"), (CacheLoader)new InstantPageCacheLoader(), cacheSettings);
        }
        return cache;
    }

    public static BrikitList<Locale> getKnownLocales() {
        if (knownLocales == null) {
            knownLocales = new BrikitList();
        }
        return knownLocales;
    }

    protected static String pageIdFromKey(String cacheKey) {
        return (String)new BrikitList((List)BrikitString.split((String)cacheKey, (String)":")).first();
    }

    public static synchronized void put(AbstractPage abstractPage, Locale locale, boolean isComalaPublished, boolean isPhone, String renderedPage) {
        InstantPageCache.getCache().put((Object)InstantPageCache.cacheKey(abstractPage, locale, isComalaPublished, isPhone), (Object)renderedPage);
    }

    public static synchronized void reset() {
        BrikitLog.logDebug((String)Confluence.getText((String)"com.brikit.themepress.instant.page.cache.reset.debug.all"));
        InstantPageCache.getCache().removeAll();
    }

    public static synchronized void reset(long pageId) {
        BrikitLog.logDebug((String)(Confluence.getText((String)"com.brikit.themepress.instant.page.cache.reset.debug.id") + pageId));
        String pageIdAsString = Long.toString(pageId);
        InstantPageCache.reset(pageIdAsString);
    }

    public static synchronized void reset(String pageId) {
        for (Locale locale : InstantPageCache.getKnownLocales()) {
            InstantPageCache.getCache().remove((Object)InstantPageCache.cacheKey(pageId, locale, true, true));
            InstantPageCache.getCache().remove((Object)InstantPageCache.cacheKey(pageId, locale, true, false));
            InstantPageCache.getCache().remove((Object)InstantPageCache.cacheKey(pageId, locale, false, true));
            InstantPageCache.getCache().remove((Object)InstantPageCache.cacheKey(pageId, locale, false, false));
        }
    }

    public static void reset(AbstractPage abstractPage) {
        BrikitLog.logDebug((String)(Confluence.getText((String)"com.brikit.themepress.instant.page.cache.reset.debug.title") + abstractPage.getTitle()));
        InstantPageCache.reset(abstractPage.getIdAsString());
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().maxEntries(10000).build();
    }

    protected static class InstantPageCacheLoader
    implements CacheLoader<String, String> {
        protected InstantPageCacheLoader() {
        }

        @Nonnull
        public String load(@Nonnull String pageId) {
            return "";
        }
    }
}

