(function ($) {
	ThemePress.BlogTree = {

		blogTree: function () {
			return $(".blog-tree");
		},
		
		drawBlogEntries: function (node, list) {
			if (!list || !list.length) return;

			// Dump any wait message
			node.find(".blog-loading").remove();
	
			var $sub = $("<ul>").addClass("ia-subpagetree blog-entries");
			$(list).each(function () {
				var $icon = $("<span>").addClass("icon icon-section");
				var $a = $("<a>")
							.attr("href", this.url)
							.text(this.title);
				var $li = $("<li>")
							.addClass("acs-tree-item leaf blog-entry")
							.append($icon)
							.append($a);
				if (this.url == (ThemePress.contextPath + ThemePress.pageUrl)) $li.addClass("current");
				
				$sub.append($li);
			});
			node.append($sub);
		},
		
		drawBlogMonths: function (node, list) {
			if (!list || !list.length) return;

			// Dump any wait message
			node.find(".blog-loading").remove();
	
			var $sub = $("<ul>").addClass("ia-subpagetree blog-months");
			$(list).each(function () {
				// Month and year come in reverse order for the blostpost month list URL (plus adjust for zero-indexed months)
				var yearMonth = this.groupValue.split("/")[1] + "/" + (1 + parseInt(this.groupValue.split("/")[0]));
				var $icon = $("<span>").addClass("icon icon-section")
								.addClass(this.children.length ? "icon-section-opened" : "icon-section-closed");
				var $a = $("<a>")
							.attr("href", ThemePress.contextPath + "/display/" + ThemePress.spaceKey + "/" + yearMonth)
							.text(this.title);
				var $li = $("<li>")
							.addClass("acs-tree-item grouping blog-month")
							.addClass(this.children.length ? "opened" : "closed")
							.attr("data-group-type", "2")
							.attr("data-group-value", this.groupValue)
							.append($icon)
							.append($a);
				if ($(this.children).length) $li.addClass("current");
				$icon.click(ThemePress.BlogTree.expandBlogMonth);
				$a.click(ThemePress.BlogTree.expandBlogMonth);
				ThemePress.BlogTree.drawBlogEntries($li, this.children);
				$sub.append($li);
			});
			node.append($sub);
		},
		
		drawBlogTree: function (response) {
			
			// var $tree = $("<div class='ia-secondary-container'></div>");
			var $ul = $("<ul>").addClass("ia-plugin_pagetree blog-years");
			
			$(response).each(function () {
				var $icon = $("<span>").addClass("icon icon-section")
								.addClass(this.children.length ? "icon-section-opened" : "icon-section-closed");
				var $a = $("<a>").attr("href", ThemePress.contextPath + "/display/" + ThemePress.spaceKey + "/" + this.groupValue)
								.text(this.title);
				var $li = $("<li>")
					.addClass("acs-tree-item grouping blog-year")
					.addClass(this.children.length ? "opened" : "closed")
					.attr("data-group-type", "1")
					.attr("data-group-value", this.groupValue)
					.append($icon)
					.append($a);
				$icon.click(ThemePress.BlogTree.expandBlogYear);
				$a.click(ThemePress.BlogTree.expandBlogYear);
				ThemePress.BlogTree.drawBlogMonths($li, this.children);
				$ul.append($li);
			});
			ThemePress.BlogTree.blogTree()
				.after($ul)
				.remove();
		},
		
		expandBlogMonth: function (event) {
	
			event.stopPropagation();
			event.preventDefault();
			
			var $li = $(this).closest("li");

			if ($li.hasClass("opened")) {
				$li.toggleClass("opened closed").find("ul").hide();
			}
			else {
				var $sub = $li.find("ul").not(".blog-loading");
				if ($sub.length) {
					$sub.show().closest("li").toggleClass("closed opened");
				}
				else {
					// Bail if already loading
					if ($li.closest("ul").find(".blog-loading").length) return false;

					$li.toggleClass("closed opened")
						.append("<ul class='blog-loading'><li style='list-style-type:none'><img class='wait' src='" + ThemePress.contextPath + "/images/icons/wait.gif' /></li></ul>");
					var url = contextPath + "/rest/ia/1.0/pagetree/blog/subtree";
					var data = {spaceKey: ThemePress.spaceKey, groupType: $li.data("group-type"), groupValue: $li.data("group-value")};
					$.get(url, data).done(function (response) {
						ThemePress.BlogTree.drawBlogEntries($li, response);
					});
				}
			}
			$li.find(".icon-section").toggleClass("icon-section-opened icon-section-closed");
		},
		
		expandBlogYear: function (event) {
	
			event.stopPropagation();
			event.preventDefault();
			
			var $li = $(this).closest("li");

			if ($li.hasClass("opened")) {
				$li.toggleClass("opened closed").find("ul").hide();
			}
			else {
				var $sub = $li.find("ul").not(".blog-loading");
				if ($sub.length) {
					$sub.show().closest("li").toggleClass("closed opened");
				}
				else {
					// Bail if already loading
					if ($li.closest("ul").find(".blog-loading").length) return false;

					$li.toggleClass("closed opened")
						.append("<ul class='blog-loading'><li style='list-style-type:none'><img class='wait' src='" + ThemePress.contextPath + "/images/icons/wait.gif' /></li></ul>");
					var url = contextPath + "/rest/ia/1.0/pagetree/blog/subtree";
					var data = {spaceKey: ThemePress.spaceKey, groupType: $li.data("group-type"), groupValue: $li.data("group-value")};
					$.get(url, data).done(function (response) {
						ThemePress.BlogTree.drawBlogMonths($li, response);
					});
				}
			}
			$li.find(".icon-section").toggleClass("icon-section-opened icon-section-closed");
		},
		
		load: function () {
			$.get(ThemePress.contextPath + "/rest/ia/1.0/pagetree/blog", {pageId: ThemePress.pageId}, ThemePress.BlogTree.drawBlogTree);
		} 

	};

})(jQuery);

ThemePress.toInit(function ($) {
	if (!ThemePress.BlogTree.blogTree().length) return;

	ThemePress.BlogTree.load();
});
