/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.AbstractPageDesignActionSupport;
import com.brikit.themepress.util.PageDesignerResponse;
import java.util.ArrayList;
import java.util.List;

public class MovePageElementAction
extends AbstractPageDesignActionSupport {
    protected String containerId;
    protected String containerType;
    protected String elementId;
    protected String elementType;
    protected String targetId;
    protected String targetLayerId;
    protected String after;

    public String execute() throws Exception {
        List<MacroDefinition> blocksRemaining;
        String body = Confluence.getBodyAsString((ContentEntityObject)this.getPage());
        MacroDefinition moving = this.getPageWrapper().contentMacroFromStorageFormat(body, "content-" + this.getElementType(), this.getElementId());
        MacroDefinition target = this.getPageWrapper().contentMacroFromStorageFormat(body, "content-" + this.getElementType(), this.getTargetId());
        MacroDefinition container = this.getPageWrapper().contentMacroFromStorageFormat(body, "content-" + this.getContainerType(), this.getContainerId());
        if (moving == null) {
            return this.setJSONError("Cannot find content-" + this.getElementType() + " macro " + this.getElementId() + " on " + this.getPage());
        }
        if (container == null) {
            return this.setJSONError("Cannot find content-" + this.getContainerType() + " macro " + this.getContainerId() + " on " + this.getPage());
        }
        String newBody = MacroParser.removeMacroFromStorageFormat((AbstractPage)this.getPage(), (String)body, (MacroDefinition)moving);
        MacroDefinition layer = this.getPageWrapper().layerFromStorageFormat(newBody, this.getLayerId());
        if (layer == null) {
            return this.setJSONError("Cannot find content-layer macro " + this.getLayerId() + " on " + this.getPage());
        }
        if (!this.getLayerId().equals(this.getTargetLayerId()) && (blocksRemaining = this.getPageWrapper().blocksFromStorageFormat(layer.getBodyText())).isEmpty()) {
            newBody = MacroParser.removeMacroFromStorageFormat((AbstractPage)this.getPage(), (String)newBody, (MacroDefinition)layer);
        }
        if (target == null) {
            container = MacroParser.firstMacroFromStorageFormat((AbstractPage)this.getPage(), (String)newBody, (String)("content-" + this.getContainerType()), (String)"id", (String)this.getContainerId());
            MacroDefinition newContainer = MacroParser.clone((MacroDefinition)container);
            MacroParser.setBody((MacroDefinition)newContainer, (String)(container.getBodyText() + MacroParser.macroAsStorageFormat((AbstractPage)this.getPage(), (MacroDefinition)moving)));
            newBody = MacroParser.replaceMacroInStorageFormat((AbstractPage)this.getPage(), (String)newBody, (MacroDefinition)container, (MacroDefinition)newContainer);
        } else {
            target = this.getPageWrapper().contentMacroFromStorageFormat(newBody, "content-" + this.getElementType(), this.getTargetId());
            newBody = MacroParser.insertMacroIntoStorageFormat((AbstractPage)this.getPage(), (String)newBody, (MacroDefinition)moving, (MacroDefinition)target, (!BrikitString.isSet((String)this.getAfter()) ? 1 : 0) != 0);
        }
        if (this.getPageWrapper().contentMacroFromStorageFormat(newBody, "content-" + this.getElementType(), this.getElementId()) == null) {
            return this.setJSONError("There was a problem moving content-" + this.getElementType() + " macro " + this.getElementId());
        }
        newBody = this.getPageWrapper().rebalanceColumnsFromStorageFormat(newBody);
        Confluence.savePage((AbstractPage)this.getPage(), (String)newBody, (String)(this.getElementType() + " moved"), (boolean)false);
        ArrayList<MacroDefinition> elements = new ArrayList<MacroDefinition>();
        elements.add(this.getPageWrapper().layer(this.getLayerId()));
        if (!this.getLayerId().equals(this.getTargetLayerId())) {
            elements.add(this.getPageWrapper().layer(this.getTargetLayerId()));
        }
        JSONObject json = PageDesignerResponse.jsonResponse(this.getPage(), true, elements, "move", this.isReload());
        json.put("id", (Object)("content-" + this.getElementType() + "-" + this.getElementId()));
        this.setJSONResult(json);
        return "success";
    }

    @Override
    public String getAfter() {
        return this.after;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerType() {
        return this.containerType;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public String getElementType() {
        return this.elementType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetLayerId() {
        return this.targetLayerId;
    }

    @Override
    public void setAfter(String after) {
        this.after = after;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    @Override
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @Override
    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTargetLayerId(String targetLayerId) {
        this.targetLayerId = targetLayerId;
    }
}

