(function ($) {
	ThemePress.CategorySettings = {

		clearCategorySpaceArchitectSettings: function (event) {
			event.stopPropagation();
			var $link = $(this);
			var category = $link.data("category");
			ThemePress.Dialog2.doubleConfirm("<p>" + ThemePress.getText("com.brikit.themepress.clear.space.architect.settings.for.category", [category]) + "</p>", 
				  { title: ThemePress.getText("com.brikit.themepress.clear.space.architect.settings.for.category.confirm"), 
					  okButton: ThemePress.getText("com.brikit.themepress.clear.space.architect.settings.for.category.confirm") 
				  }, function (dialog) {
					dialog.hide();
					$.post($link.attr("href"), {categoryName: category}, ThemePress.CategorySettings.settingsCleared);
				}
			);
			return false;
		},
		
		settingsCleared: function (result) {
			if ($(result).hasClass("errorMessage")) {
				ThemePress.Dialog2.alert(ThemePress.getText("com.brikit.themepress.clear.space.architect.settings.for.category.error"), { title: ThemePress.getText("com.brikit.themepress.error") });
			}
			else {
				ThemePress.Dialog2.alert(
					"<p>" + ThemePress.getText("com.brikit.themepress.clear.space.architect.settings.for.category.success", [result]) + "</p>",
					{ title: ThemePress.getText("com.brikit.themepress.success") }
				);
			}
		},
		
	 	toggleHelpPanel: function () {
			var $helpPanel = $("#space-category-settings-help");
			$(this).toggleAttr("aria-pressed", "true");
			$helpPanel.slideToggle();
			
	 	},
		
		upload: function (event) {

			var $uploadForm = $("#upload-settings-form");
			var $inputField = $uploadForm.find("#uploadsettings");

			// Clear out then trigger the hidden file upload form
			$inputField.val("").click();

			// When the upload filename changes, automagically upload the file and invoke the import action...
			$inputField.unbind().change(function () { 
				// ...on File selection, confirm before importing
				var fileName = $inputField.val().split('\\').pop();
				ThemePress.Dialog2.doubleConfirm("<p>" + ThemePress.getText("com.brikit.themepress.import.space.category.settings.question", [fileName]) + "</p>", 
				  { title: ThemePress.getText("com.brikit.themepress.import.space.category.settings.confirm"), 
					  okButton: ThemePress.getText("com.brikit.themepress.import.space.category.settings.confirm") 
				  }, function (dialog) {
					dialog.hide();
					$uploadForm.submit();
				});
				return false;
			});
		
			// Convert file upload to ajax submission (using the jquery.form plugin)
			// On submission of the file upload, check server response for errors
			$uploadForm.ajaxForm(function (result) {
				if ($(result).hasClass("errorMessage")) {
					ThemePress.Dialog2.alert(result, { title: ThemePress.getText("com.brikit.themepress.file.upload.error") }, ThemePress.reloadBrowser);
				}
				else {
					ThemePress.Dialog2.alert(
						"<p>" + ThemePress.getText("com.brikit.themepress.reloading") + "</p>",
						{ title: ThemePress.getText("com.brikit.themepress.success") }
					);
					ThemePress.reloadBrowser(1000);
				}
			});

			return false;
		}
				
	};

})(jQuery);

ThemePress.toInit(function ($) {
	$("#space-category-settings-toolbar-help").click(ThemePress.CategorySettings.toggleHelpPanel);
	$("#upload-settings").click(ThemePress.CategorySettings.upload);
	$(".clear-category-space-architect-settings").click(ThemePress.CategorySettings.clearCategorySpaceArchitectSettings);
});
