/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitNumber;
import com.brikit.themepress.model.PageWrapper;

public class EditBlogPostAction
extends com.atlassian.confluence.pages.actions.EditBlogPostAction {
    protected String blockId;

    public String doDefault() throws Exception {
        String result = super.doDefault();
        long blockId = BrikitNumber.parseLong(this.getBlockId());
        if (blockId < 0L) {
            this.blockId = PageWrapper.get(this.getPage()).addBlocks(-1 * (int)blockId);
            return "blocksAdded";
        }
        MacroDefinition macro = this.getBlockMacro();
        if (macro != null) {
            this.setWysiwygContent(Confluence.convertToEditorContent(macro.getBodyText(), this.getPage()));
        }
        return result;
    }

    public String getBlockId() {
        return this.blockId;
    }

    protected MacroDefinition getBlockMacro() {
        try {
            return PageWrapper.get(this.getPage()).block(this.getBlockId());
        }
        catch (XhtmlException ex) {
            BrikitLog.logError("Failed to parse content-block macros on " + this.getPage(), (Exception)((Object)ex));
            return null;
        }
    }

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    public void validate() {
        super.validate();
        MacroDefinition macro = this.getBlockMacro();
        try {
            if (macro != null) {
                this.storageFormat = MacroParser.replaceMacroBodyOnPage(this.getPage(), macro, this.storageFormat);
            }
        }
        catch (Exception ex) {
            this.addActionError(this.getText("brikit.block.content.replacement.failed"), new Object[]{ex});
        }
    }
}

