/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.themepress.html.RichLinkContent;
import com.brikit.themepress.html.RichLinkContentCache;
import java.util.Map;

public class DefineRichLinkMacro
extends BrikitNoBodyMacro {
    public static final String PAGE_PARAM = "link";
    public static final String URL_PARAM = "url";
    public static final String TITLE_PARAM = "title";
    public static final String DESCRIPTION_PARAM = "description";
    public static final String IMAGE_PARAM = "image";
    public static final String IMAGE_LOCATION_PARAM = "image-location";
    public static final String SITE_LOGO_PARAM = "site-logo";
    public static final String LOGO_LOCATION_PARAM = "site-logo-location";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        RichLinkContent richLinkContent;
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.hasStringValue(URL_PARAM)) {
            richLinkContent = RichLinkContent.wget(macroContext.stringValue(URL_PARAM));
        } else if (macroContext.hasStringValue(PAGE_PARAM)) {
            richLinkContent = RichLinkContentCache.getRichLinkContent(macroContext.pageFromValue(PAGE_PARAM));
        } else {
            throw new MacroExecutionException("Must input either a page title or web address to render rich link.");
        }
        AbstractPage imageAttachmentPage = null;
        AbstractPage logoAttachmentPage = null;
        if (macroContext.hasStringValue(IMAGE_LOCATION_PARAM)) {
            imageAttachmentPage = macroContext.pageFromValue(IMAGE_LOCATION_PARAM, macroContext.getPage());
        }
        if (macroContext.hasStringValue(LOGO_LOCATION_PARAM)) {
            logoAttachmentPage = macroContext.pageFromValue(LOGO_LOCATION_PARAM, macroContext.getPage());
        }
        if (macroContext.hasStringValue(TITLE_PARAM)) {
            richLinkContent.setTitle(macroContext.stringValue(TITLE_PARAM));
        }
        if (macroContext.hasStringValue(DESCRIPTION_PARAM)) {
            richLinkContent.setDescription(macroContext.stringValue(DESCRIPTION_PARAM));
        }
        if (macroContext.hasStringValue(IMAGE_PARAM)) {
            richLinkContent.setImage(macroContext.getImageUrl(macroContext.stringValue(IMAGE_PARAM), imageAttachmentPage));
        }
        if (macroContext.hasStringValue(SITE_LOGO_PARAM)) {
            richLinkContent.setSiteLogo(macroContext.getImageUrl(macroContext.stringValue(SITE_LOGO_PARAM), logoAttachmentPage));
        }
        return RichLinkContent.render(richLinkContent);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

