/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.extractor;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.util.Collection;
import java.util.Collections;
import org.springframework.stereotype.Component;

@Component(value="macroParameterExtractor")
public class MacroParameterExtractor
implements Extractor2 {
    protected static final StringBuilder EMPTY_STRING_BUILDER = new StringBuilder(0);

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        return Collections.emptyList();
    }

    public StringBuilder extractText(Object searchable) {
        if (!(searchable instanceof AbstractPage)) {
            return EMPTY_STRING_BUILDER;
        }
        BrikitList<String> macroParameters = TargetedSearch.getSearchMacroParametersList();
        BrikitList searchText = new BrikitList();
        for (String spec : macroParameters) {
            BrikitList bits = BrikitString.split((String)spec, (String)"\\.");
            if (bits.size() != 2) {
                BrikitLog.logWarning((String)("Macro parameter " + spec + " specified for indexing does not follow format: macro-key.parameter-name"));
                continue;
            }
            String macroName = (String)bits.first();
            String macroParam = (String)bits.last();
            try {
                for (MacroDefinition macro : MacroParser.extractMacros((AbstractPage)((AbstractPage)searchable), (String)macroName, (String)macroParam)) {
                    searchText.add((Object)MacroParser.getStringParameter((MacroDefinition)macro, (String)macroParam));
                }
            }
            catch (XhtmlException ex) {
                BrikitLog.logError((String)("Unable to index macro parameter " + spec + " for: " + String.valueOf(searchable)), (Exception)((Object)ex));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(searchText.join(" "));
        return builder;
    }
}

