/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.util.actions.ContentTypesDisplayMapper;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.CQLComposer;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class ComposeCQLAction
extends AbstractTargetedSearchAction {
    protected CQLComposer cqlComposer;
    protected int maxResults;
    protected boolean displayRichLinks;
    protected String result;

    @PermittedMethods(value={HttpMethod.POST})
    @AnonymousSiteAccess
    public String execute() {
        JSONObject json = new JSONObject();
        json.put("cql", (Object)this.getCqlComposer().cql());
        json.put("success", true);
        this.setResult(json.toString());
        return "success";
    }

    protected CQLComposer getCqlComposer() {
        if (this.cqlComposer == null) {
            this.cqlComposer = new CQLComposer();
        }
        return this.cqlComposer;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public String getResultHTML() {
        return this.result;
    }

    public String getResultType(SearchResult searchResult) {
        String type = searchResult.getType().toLowerCase();
        if (type.contains("attachment")) {
            return ContentTypesDisplayMapper.getIconForAttachment((String)searchResult.getType(), (String)searchResult.getDisplayTitle());
        }
        ContentTypesDisplayMapper mapper = (ContentTypesDisplayMapper)ContainerManager.getComponent((String)"contentTypesDisplayMapper");
        return mapper.getClassName(searchResult);
    }

    public boolean isDisplayRichLinks() {
        return this.displayRichLinks;
    }

    @StrutsParameter
    public void setAdditionalFilters(List<String> additionalFilters) {
        this.getCqlComposer().setAdditionalFilters(additionalFilters);
    }

    @StrutsParameter
    public void setContentTypes(List<String> contentTypes) {
        this.getCqlComposer().setContentTypes(contentTypes);
    }

    @StrutsParameter
    public void setContributor(String contributor) {
        BrikitList contributorList = new BrikitList();
        contributorList.add(contributor);
        this.setContributors((List<String>)contributorList);
    }

    @StrutsParameter
    public void setContributors(List<String> contributors) {
        this.getCqlComposer().setContributors((BrikitList<String>)new BrikitList(contributors));
    }

    @StrutsParameter
    public void setDisplayRichLinks(boolean displayRichLinks) {
        this.displayRichLinks = displayRichLinks;
    }

    @StrutsParameter
    public void setExcludeFilters(List<String> excludeLabels) {
        this.getCqlComposer().setExcludeFilters(excludeLabels);
    }

    @StrutsParameter
    public void setFilterOption(String option) {
        this.getCqlComposer().setFilterOption(option);
    }

    @StrutsParameter
    public void setLastModified(String lastModified) {
        this.getCqlComposer().setLastModified(lastModified);
    }

    @StrutsParameter
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @StrutsParameter
    public void setQueryString(String queryString) {
        this.getCqlComposer().setQueryString(queryString);
    }

    @Override
    public void setResult(String result) {
        this.result = result;
    }

    @StrutsParameter
    public void setSearchFilters(List<String> searchFilters) {
        this.getCqlComposer().setSearchFilters((List<String>)BrikitList.removeBlanks(searchFilters));
    }

    @StrutsParameter
    public void setSearchPageTitles(boolean searchPageTitles) {
        this.getCqlComposer().setSearchPageTitles(searchPageTitles);
    }

    @StrutsParameter
    public void setSearchScope(List<String> searchScope) {
        this.getCqlComposer().setSearchScope(searchScope);
    }

    @StrutsParameter
    public void setSortBy(String sortBy) {
        this.getCqlComposer().setSortBy(BrikitString.escapeXML((String)sortBy));
    }

    @StrutsParameter
    public void setSpaceSearchScope(List<String> searchScope) {
        this.getCqlComposer().setSpaceSearchScope(searchScope);
    }

    @StrutsParameter
    public void setWildcard(boolean wildcard) {
        this.getCqlComposer().setWildcardSearch(wildcard);
    }
}

