(function ($) {
	
	TargetedMobileSearchPanel = function (searchPanel) {
		this.searchPanel = $(searchPanel);
		this.initialize();
	};
	
	Object.assign(TargetedMobileSearchPanel.prototype, {

		addFilters: function () {
			$.post(TargetedSearch.contextPath + "/plugins/targetedsearch/mobile/searchfilters.action", this.loadFilters.bind(this));
		},
	
		clearAllFilters: function (event) {
			event.preventDefault();
			this.filters.find("input").removeProp("checked");
			this.filters.find("input[name='date-range']:first").prop("checked", "checked");
			this.filters.find("input.autocomplete-user").val("");
			this.filtersChanged();
		},
	
		closeFilters: function (event) {
			event.preventDefault();
			this.toggleFilters();
			if (this.changed) this.doSearch();
		},
	
		encodeDateRange: function () {
			var dateRange = $(".date-range:checked").val();
			return dateRange ? "&lastModified=" + encodeURIComponent(dateRange) : "";
		},

		doSearch: function (event) {
			if (event) event.preventDefault();
				
			var data = this.searchForm.serialize();

			// Add selected filters 
			data = data + TargetedSearch.ResultsBrowser.prototype.collectFilters();
			var types = TargetedSearch.ResultsBrowser.prototype.collectContentTypes();
			if (!types) types = "&contentTypes=page&contentTypes=blogpost";
			data = data + types;
			data = data + this.encodeDateRange();
			data = data + TargetedSearch.ResultsBrowser.prototype.encodeContributor();
			data = data + TargetedSearch.ResultsBrowser.prototype.collectSpaceCategories();

			this.moreResultsLoader.restartSearch(data, "", this.searchResultsLoaded.bind(this));
			// $.post(TargetedSearch.contextPath + "/plugins/targetedsearch/composecql.action",
			// 	data,
			// 	function (response) {
			// 		if (this.debug) console.log(response.cql);
			// 		this.moreResultsLoader.empty();
			// 		this.moreResultsLoader.cql(response.cql);
			// 		this.moreResultsLoader.nextResult(0);
			// 		this.moreResultsLoader.addLoadTrigger(true, );
			// 		this.changed = false;
			// 	}.bind(this),
			// 	"json"
			// );

			this.searchResults.addClass("results-loaded");

			return false;
		},
	
		filtersChanged: function () {
			this.changed = true;
		},
	
		initialize: function () {
			this.searchForm = this.searchPanel.find(".search-form");
			this.searchField = this.searchForm.find("input");
		
			$(".mobile-search-form .targeted-search-field-query").val(this.searchField.val());
		
			this.resultsHeader = this.searchPanel.find(".results-header");
			this.resultsDisplay = this.searchPanel.find(".total-results");			
			this.searchStringDisplay = this.searchPanel.find(".search-string");
			this.searchResults = this.searchPanel.find(".search-results");

			this.searchPanel.find(".filter-trigger-button").click(this.toggleFilters.bind(this));

			this.filterPanel = $(".mobile-search-filters-panel");
			this.filterPanel.find(".closer").click(this.closeFilters.bind(this));
			this.filterPanel.find(".clear-all").click(this.clearAllFilters.bind(this));
		
			this.searchPanel.on("scroll touchmove mousewheel", function (e) { e.stopPropagation(); });
		
			this.searchResultsList = this.searchPanel.find(".search-results-list");
			// this.moreResultsLoader = new TargetedSearch.MoreResultsLoader(this.searchResultsList, this.searchResults);
			this.moreResultsLoader = $(".more-results-scroll-loader").data("more-results-loader");
		
			this.doSearch();

		},
	
		loadFilters: function (response) {
			this.filters = this.filterPanel.find(".mobile-search-filters").prepend(response);
		
			// Don't let the filter form fire on its own
			this.filters.find("#results-filters, #filter-form").submit(function () { return false; });
		
			this.filters.find(".default-options-select").each(function () {
				$(this).addClass("brikit-expander");
				$(".search-filter-section", this).addClass("brikit-expander-control").append(TargetedSearch.auiIcon("collapsed", "expander-icon"));
				$("fieldset", this).addClass("brikit-expander-content");
			});
			this.filters.find(".brikit-expander .expanded").removeClass("expanded");
			this.filters.find(".brikit-expander").initializeExpanderIE11Safe();
		
			this.filters.find("input").change(this.filtersChanged.bind(this));
			this.filters.find("input.autocomplete-user").bind("selected.autocomplete-user-or-group", this.filtersChanged.bind(this));

			Confluence.Binder.autocompleteUserOrGroup(this.filters);
		},
	
		searchResultsLoaded: function (resultsData) {
			this.changed = false;
			this.searchStringDisplay.text(this.searchField.val());
			this.resultsDisplay.text(resultsData.totalMatches);
			this.resultsHeader.show();
		},
	
		toggleFilters: function () {
			if (!this.filters) this.addFilters();
			$("body").toggleClass("search-filters-on");
			return false;
		}

	});	
	
})(jQuery);

TargetedSearch.toFinalize(function ($) {
	if (ThemePress && ThemePress.Browser.mobile) $(".mobile-search-panel").each(function () {  new TargetedMobileSearchPanel(this); });
});
