/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.brikit.core.confluence.Confluence;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import java.util.ArrayList;
import java.util.List;

public class SelectLabelFieldAction
extends AbstractTargetedSearchAction {
    protected String filterGroupName;
    protected List<String> labels;
    protected FilterGroup filterGroup;

    @Override
    public String execute() {
        for (Filter filter : this.getFilterGroup().getFiltersWithSubcategories()) {
            boolean hasLabel = Confluence.hasLabel((AbstractLabelableEntityObject)this.getPage(), filter.getLabel());
            if (this.getLabels().contains(filter.getLabel())) {
                if (!hasLabel) {
                    Confluence.addLabel(filter.getLabel(), this.getPage());
                }
                for (String parentLabel : filter.getParentLabels()) {
                    if (Confluence.hasLabel((AbstractLabelableEntityObject)this.getPage(), parentLabel)) continue;
                    Confluence.addLabel(parentLabel, this.getPage());
                }
                continue;
            }
            if (!hasLabel) continue;
            Confluence.removeLabel(filter.getLabel(), this.getPage());
        }
        return "success";
    }

    public String setSpaceCategory() throws Exception {
        if (!Confluence.canAdministerSpace(this.getSpaceKey())) {
            this.addActionError(Confluence.getText("filterGroupName.insufficient.permissions", new Object[]{this.getFilterGroupName()}));
            return "error";
        }
        for (Filter filter : this.getFilterGroup().getFilters()) {
            Label label;
            boolean hasLabel = Confluence.spaceHasCategory(this.getSpaceKey(), filter.getLabel());
            if (this.getLabels().contains(filter.getLabel())) {
                if (hasLabel) continue;
                Confluence.addSpaceLabel(filter.getLabel(), this.getSpaceKey());
                continue;
            }
            if (!hasLabel || (label = Confluence.findLabel(filter.getLabel(), (ContentEntityObject)Confluence.getSpace(this.getSpaceKey()).getDescription())) == null) continue;
            Confluence.removeSpaceLabel(label, this.getSpaceKey());
        }
        return "success";
    }

    public FilterGroup getFilterGroup() {
        if (this.filterGroup == null) {
            this.filterGroup = FilterGroup.getFilterGroupByName(this.getFilterGroupName());
        }
        return this.filterGroup;
    }

    public String getFilterGroupName() {
        return this.filterGroupName;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        return this.labels;
    }

    @Override
    public String getSpaceKey() {
        return Confluence.getSpaceKey(this.getPage());
    }

    public void setFilterGroupName(String filterGroupName) {
        this.filterGroupName = filterGroupName;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void validate() {
        super.validate();
        if (this.getFilterGroup() == null) {
            this.addActionError(Confluence.getText("filterGroupName.insufficient.permissions", new Object[]{this.getFilterGroupName()}));
        }
    }
}

