(function ($) {

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];

	BrikitCore.Events = {
		
		// List of callback functions
		callbackFunctions: {},

		// Add one or more event types. To provide multiple names, eventTypes can be space delimited.
		addEventTypes: function (eventTypes) {
			$.each(eventTypes.split(" "), function (index, value) {
				if (BrikitCore.Events.callbackFunctions[value]) console.error("BrikitCore.Events.addEventType error: " + value + " is already defined.");
				else BrikitCore.Events.callbackFunctions[value] = [];
			});
		},
		
		// Register a callback function for the named event type. To provide multiple names, eventTypes can be space delimited.
		// Callback functions that return false will stop the callbacks from firing the event, if applicable (typically events with 
		// Will in the name, such as toolbarWillChange, will respect these return values).
		addCallback: function (eventTypes, callback) {
			$.each(eventTypes.split(" "), function (index, value) {
				if (BrikitCore.Events.callbackFunctions[value]) BrikitCore.Events.callbackFunctions[value].push(callback);
				else console.error("BrikitCore.Events.addCallback error: Event type " + value + " is undefined.");
			});
		},

		// Fire the queued callback functions to run after the named callback event
		// Example: 
		// 		var okay = BrikitCore.Events.fireCallbacks("toolbarWillChange", $toolbar);
		// 		if (okay) BrikitCore.Events.toggleToolbar("fast");
		fireCallbacks: function () {
			var args = Array.prototype.slice.call(arguments);
			var okay = true;
			var callbackType = args.shift();
			if (typeof(callbackType) == "string") callbackType = callbackType.split(" ");
			var callbackParam = args.shift();
			$(callbackType).each( function () {
				// Explicitly check for returnValue != false from the callback, since the return value may be undefined
				if (okay) $(BrikitCore.Events.callbackFunctions[this]).each(function () {
					var callOkay = this(callbackParam);
					if (typeof(callOkay) != "undefined") okay = okay && callOkay;
				});
			});
			return okay;
		}

	};

})(jQuery);

