/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.PageRestricter;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.PublishedPage;
import com.brikit.contentflow.model.ScheduledPage;
import com.brikit.contentflow.settings.PublishDateManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import java.io.Serializable;
import javax.activation.DataSource;

public class Publisher {
    public static final String SHOW_PUBLISHED_VERSION = "published";
    protected static final String DATE_FORMAT = "yyyy-MM-dd";

    protected static boolean canSwitch(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage != null && ContentFlowConfiguration.canUseWorkflows(activeObjects, abstractPage) && PageWorkflow.hasActiveWorkflow(activeObjects, abstractPage) && PageWorkflow.userIsMemberOfPublishingWorkflow(activeObjects, abstractPage);
    }

    public static boolean canSwitchToPublishedVersion(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return Publisher.canSwitch(activeObjects, abstractPage) && !Publisher.isPublishedVersionRequested() && abstractPage.getVersion() != Publisher.getPublishedVersion(activeObjects, abstractPage);
    }

    public static boolean canSwitchToUnpublishedVersion(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return Publisher.canSwitch(activeObjects, abstractPage) && Publisher.isPublishedVersionRequested() && Publisher.hasPublishedVersion(activeObjects, abstractPage);
    }

    public static boolean displayingDraft(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (!PageWorkflow.hasActiveWorkflow(activeObjects, abstractPage)) {
            return false;
        }
        if (!Publisher.hasPublishedVersion(activeObjects, abstractPage)) {
            return true;
        }
        return Publisher.canSwitchToPublishedVersion(activeObjects, abstractPage);
    }

    public static DataSourceFactory getDataSourceFactory() {
        return (DataSourceFactory)ContainerManager.getComponent((String)"dataSourceFactory");
    }

    public static NotificationsSender getNotificationsSender() {
        return (NotificationsSender)ContainerManager.getComponent((String)"notificationsSender");
    }

    public static int getPublishedVersion(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        if (publishedPage == null) {
            return abstractPage.getVersion();
        }
        ContentEntityObject published = Confluence.getPageVersion((ContentEntityObject)abstractPage, (int)publishedPage.getPublishedVersion());
        return published == null || !(published instanceof AbstractPage) ? abstractPage.getVersion() : publishedPage.getPublishedVersion();
    }

    public static AbstractPage getVersionToDisplay(ActiveObjects activeObjects, AbstractPage abstractPage, boolean showPublished) {
        if (!ContentFlowConfiguration.canUseWorkflows(activeObjects, abstractPage)) {
            return abstractPage;
        }
        if (!showPublished && PageWorkflow.userIsMemberOfPublishingWorkflow(activeObjects, abstractPage)) {
            return abstractPage;
        }
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, abstractPage);
        if (pageWorkflow == null || pageWorkflow.getWorkflow().isRouting()) {
            return abstractPage;
        }
        return (AbstractPage)Confluence.getPageVersion((ContentEntityObject)abstractPage, (int)Publisher.getPublishedVersion(activeObjects, abstractPage));
    }

    public static boolean hasPublishedVersion(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        return publishedPage != null && !publishedPage.isNewPageUnderAutomaticPublishingWorkflow();
    }

    public static boolean isNewPageUnderAutomaticPublishingWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        return publishedPage != null && publishedPage.isNewPageUnderAutomaticPublishingWorkflow();
    }

    public static boolean isPublishedVersionRequested() {
        return BrikitString.isSet((String)Confluence.getHttpRequestParameter((String)SHOW_PUBLISHED_VERSION));
    }

    protected static boolean isPageScheduled(ActiveObjects activeObjects, AbstractPage abstractPage) {
        ScheduledPage scheduledPage = ScheduledPage.getScheduledPageForPage(activeObjects, abstractPage);
        return scheduledPage != null && !scheduledPage.isInScheduledWindow();
    }

    public static void publish(ActiveObjects activeObjects, AbstractPage abstractPage) {
        boolean initialVersionCreatedUnderWorkflow;
        int previousVersion = Publisher.getPublishedVersion(activeObjects, abstractPage);
        AbstractPage previousPage = (AbstractPage)Confluence.getPageVersion((ContentEntityObject)abstractPage, (int)previousVersion);
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, abstractPage);
        if (pageWorkflow != null && pageWorkflow.isPublishing()) {
            pageWorkflow.forceComplete();
        }
        boolean scheduled = Publisher.isPageScheduled(activeObjects, abstractPage);
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        boolean bl = initialVersionCreatedUnderWorkflow = publishedPage != null && publishedPage.isNewPageUnderAutomaticPublishingWorkflow();
        if (initialVersionCreatedUnderWorkflow && !scheduled) {
            PageRestricter pageRestricter = new PageRestricter(activeObjects, abstractPage);
            pageRestricter.unrestrictForPublishingWorkflow();
        }
        if (publishedPage != null) {
            publishedPage.delete();
        }
        PublishDateManager.setPublishedDateIfNotSet(abstractPage);
        Publisher.notifyWatchers(abstractPage, previousPage);
    }

    public static void notifyWatchers(AbstractPage abstractPage, AbstractPage previousPage) {
        ConfluenceUser user = Confluence.getConfluenceUser();
        UserPreferences preferences = new UserPreferences(Confluence.getUserAccessor().getPropertySet(user));
        boolean shouldNotifyOnOwnActions = preferences.getBoolean("confluence.prefs.notify.for.my.own.actions");
        NotificationData notificationData = new NotificationData((User)user, shouldNotifyOnOwnActions, (ConfluenceEntityObject)abstractPage);
        NotificationContext commonContext = notificationData.getCommonContext();
        DataSource avatarDataSource = Publisher.getDataSourceFactory().getAvatar(notificationData.getModifier());
        commonContext.setContent((ConfluenceEntityObject)abstractPage);
        commonContext.setEvent(null);
        notificationData.setSubject("$space.name > $content.title");
        notificationData.addToContext("page", (Serializable)abstractPage);
        notificationData.addToContext("content", (Serializable)abstractPage);
        notificationData.addToContext("contentType", (Serializable)((Object)abstractPage.getType()));
        notificationData.addToContext("space", (Serializable)abstractPage.getSpace());
        notificationData.addTemplateImage(Publisher.getDataSourceFactory().getServletContainerResource("/images/icons/contenttypes/page_16.png", "page-icon"));
        notificationData.addToContext("avatarCid", (Serializable)((Object)avatarDataSource.getName()));
        notificationData.addTemplateImage(avatarDataSource);
        notificationData.addToContext("originalContent", (Serializable)previousPage);
        notificationData.setTemplateName("Confluence.Templates.Mail.Notifications.pageEdit.soy");
        ContentEntityObject notificationObject = (ContentEntityObject)notificationData.getCommonContext().getMap().get("content");
        PageContext context = notificationObject.toPageContext();
        context.setOutputType("email");
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)context);
        Publisher.getNotificationsSender().sendSpaceNotifications(abstractPage.getSpace(), notificationData, (ConversionContext)conversionContext);
        Publisher.getNotificationsSender().sendPageNotifications(abstractPage, notificationData, (ConversionContext)conversionContext);
        Publisher.getNotificationsSender().sendNetworkNotifications(notificationData, (ConversionContext)conversionContext);
    }

    public boolean isPreviouslyPublished(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        return publishedPage != null;
    }

    public static void updatePublishedVersion(ActiveObjects activeObjects, AbstractPage abstractPage, int version) {
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        if (publishedPage == null) {
            publishedPage = PublishedPage.create(activeObjects, abstractPage);
        }
        publishedPage.setPublishedVersion(version);
        publishedPage.save();
    }

    public static void setPublishedVersionToCurrent(ActiveObjects activeObjects, AbstractPage abstractPage) {
        Publisher.updatePublishedVersion(activeObjects, abstractPage, Confluence.getCurrentVersionNumber((AbstractPage)abstractPage));
    }

    public static void setPublishedVersionToPrevious(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PublishedPage publishedPage = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        if (publishedPage != null) {
            return;
        }
        Publisher.updatePublishedVersion(activeObjects, abstractPage, Confluence.getPreviousVersionNumber((AbstractPage)abstractPage));
    }
}

