/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.blueprintmaker.events.cluster.BlueprintsUpdateClusterEvent;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.AccessPermission;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.PageBlueprintType;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitOrderedMap;
import com.brikit.core.util.BrikitString;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BlueprintDefinitions {
    public static final String BLUEPRINT_DEFINITIONS_FILENAME = "blueprint-definitions.json";
    public static final String SPACE_KEY_KEY = "spaceKey";
    public static final String SPACE_NAME_KEY = "spaceName";
    public static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    protected static final String SPACE_BLUEPRINTS_KEY = "spaceBlueprints";
    protected static final String ACCESS_LISTS_KEY = "accessLists";
    protected static final String BLUEPRINTS_FIELDS_KEY = "blueprintFields";
    protected static final String PAGE_BLUEPRINTS_KEY = "pageBlueprints";
    protected static final String NAME_KEY = "name";
    protected static final String PERMISSIONS_KEY = "permissions";
    protected static final String TYPE_KEY = "type";
    protected static final String CREATE_KEY = "create";
    protected static final String GRANT_KEY = "grant";
    protected static final String DESCRIPTION_KEY = "description";
    protected static final String ACCESS_KEY = "access";
    protected static final String SPACE_CATEGORIES_KEY = "spaceCategories";
    protected static final String BLUEPRINT_SPACE_KEY_KEY = "blueprintSpaceKey";
    protected static final String ID_KEY = "id";
    protected static final String REQUIRED_KEY = "required";
    protected static final String HELP_TEXT_KEY = "helpText";
    protected static final String VALIDATION_KEY = "validation";
    protected static final String PLACEHOLDER_KEY = "placeholder";
    protected static final String VALUES = "values";
    protected static final String MULTISELECT = "multiselect";
    protected static final String ADD_LABELS = "addLabels";
    protected static final String FILTER_GROUP = "filterGroup";
    protected static final String WORKFLOW_ID = "workflowId";
    protected static final String PAGE_TITLE_KEY = "pageTitle";
    protected static final String INCLUDE_CHILDREN_KEY = "includeChildren";
    protected static final String VISIBILITY_KEY = "visibility";
    protected static final String SPACE_METADATA_KEY = "spaceMetadata";
    protected static final String PAGE_METADATA_KEY = "pageMetadata";
    protected static final List<String> SPACE_METADATA_DEFAULT = Arrays.asList("atlassian.confluence.*", "com.brikit.*");
    protected static final List<String> PAGE_METADATA_DEFAULT = Arrays.asList("com.brikit.*");
    protected static final String CREATE_SPACE_GROUPS_KEY = "createSpaceGroups";
    protected static final String ANONYMOUS = "anonymous";
    protected static BrikitOrderedMap<String, SpaceBlueprint> spaceBlueprints;
    protected static BrikitOrderedMap<String, BlueprintField> blueprintFields;
    protected static BrikitOrderedMap<String, Access> accesses;
    protected static BrikitOrderedMap<String, PageBlueprint> pageBlueprints;
    protected static List<String> pageMetadata;
    protected static List<String> spaceMetadata;
    protected static List<String> createSpaceGroups;

    public static synchronized Map<String, Access> getAccesses() {
        if (accesses == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return accesses;
    }

    public static List<String> getCreateSpaceGroups() {
        if (createSpaceGroups == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return createSpaceGroups;
    }

    public static PageBlueprint getPageBlueprint(String blueprintName) {
        return (PageBlueprint)BlueprintDefinitions.getPageBlueprints().get((Object)blueprintName);
    }

    public static PageBlueprint getPageBlueprint(AbstractPage blueprintPage) {
        if (blueprintPage == null) {
            return null;
        }
        for (String blueprint : BlueprintDefinitions.getPageBlueprints().getKeysInOrder()) {
            PageBlueprint pageBlueprint = (PageBlueprint)BlueprintDefinitions.getPageBlueprints().get((Object)blueprint);
            if (pageBlueprint.getConfluencePage() == null || blueprintPage.getId() != pageBlueprint.getConfluencePage().getId()) continue;
            return pageBlueprint;
        }
        return null;
    }

    public static BrikitOrderedMap<String, PageBlueprint> getPageBlueprints() {
        if (pageBlueprints == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return pageBlueprints;
    }

    public static List<String> getPageMetadata() {
        if (pageMetadata == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return pageMetadata;
    }

    public static List<String> getSpaceMetadata() {
        if (spaceMetadata == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return spaceMetadata;
    }

    public static SpaceBlueprint getSpaceBlueprint(String blueprintName) {
        return (SpaceBlueprint)BlueprintDefinitions.getSpaceBlueprints().get((Object)blueprintName);
    }

    public static synchronized BrikitOrderedMap<String, SpaceBlueprint> getSpaceBlueprints() {
        if (spaceBlueprints == null) {
            try {
                BlueprintDefinitions.readBlueprintsFromFile(BlueprintDefinitions.getBlueprintDefinitionsFile(), false);
            }
            catch (Exception ex) {
                if (BlueprintDefinitions.getBlueprintDefinitionsFile().exists()) {
                    BrikitLog.logError((String)"Failed to read blueprint-definitions.json", (Exception)ex);
                }
                BrikitLog.logError((String)ex.getMessage(), (Exception)ex);
                spaceBlueprints = new BrikitOrderedMap();
                pageBlueprints = new BrikitOrderedMap();
                blueprintFields = new BrikitOrderedMap();
                accesses = new BrikitOrderedMap();
                pageMetadata = PAGE_METADATA_DEFAULT;
                spaceMetadata = SPACE_METADATA_DEFAULT;
                createSpaceGroups = new ArrayList<String>();
            }
        }
        return spaceBlueprints;
    }

    public static File getBlueprintDefinitionsFile() {
        return BrikitFile.getBrikitFile((String)BLUEPRINT_DEFINITIONS_FILENAME);
    }

    public static BlueprintField getBlueprintField(String name) {
        return (BlueprintField)BlueprintDefinitions.getBlueprintFields().get((Object)name);
    }

    public static synchronized BrikitOrderedMap<String, BlueprintField> getBlueprintFields() {
        if (blueprintFields == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return blueprintFields;
    }

    protected static void readBlueprintsFromFile(File aFile, boolean validateOnly) throws Exception {
        List<String> readSpaceMetadata;
        List<String> readPageMetadata;
        String fileContents = BrikitFile.readFile((File)aFile);
        JSONObject allSettingsJSON = new JSONObject(fileContents);
        List<String> list = readPageMetadata = allSettingsJSON.has(PAGE_METADATA_KEY) ? BlueprintDefinitions.valuesAsStrings(allSettingsJSON.getJSONArray(PAGE_METADATA_KEY)) : PAGE_METADATA_DEFAULT;
        if (readPageMetadata == null || readPageMetadata.isEmpty()) {
            readPageMetadata = PAGE_METADATA_DEFAULT;
        }
        List<String> list2 = readSpaceMetadata = allSettingsJSON.has(SPACE_METADATA_KEY) ? BlueprintDefinitions.valuesAsStrings(allSettingsJSON.getJSONArray(SPACE_METADATA_KEY)) : SPACE_METADATA_DEFAULT;
        if (readSpaceMetadata == null || readSpaceMetadata.isEmpty()) {
            readSpaceMetadata = SPACE_METADATA_DEFAULT;
        }
        BrikitList<String> readCreateSpaceGroups = BlueprintDefinitions.valuesAsStrings(allSettingsJSON.getJSONArray(CREATE_SPACE_GROUPS_KEY));
        BrikitOrderedMap<String, Access> readAccesses = BlueprintDefinitions.unpackAccesses(allSettingsJSON.getJSONArray(ACCESS_LISTS_KEY));
        BrikitOrderedMap<String, BlueprintField> readBlueprintFields = BlueprintDefinitions.unpackBlueprintFields(allSettingsJSON.getJSONArray(BLUEPRINTS_FIELDS_KEY));
        BrikitOrderedMap<String, PageBlueprint> readPageBlueprints = BlueprintDefinitions.unpackPageBlueprints(allSettingsJSON.getJSONArray(PAGE_BLUEPRINTS_KEY), readBlueprintFields);
        BrikitOrderedMap<String, SpaceBlueprint> readSpaceBlueprints = BlueprintDefinitions.unpackSpaceBlueprints(allSettingsJSON.getJSONArray(SPACE_BLUEPRINTS_KEY), readBlueprintFields, readAccesses);
        if (!validateOnly) {
            spaceBlueprints = readSpaceBlueprints;
            blueprintFields = readBlueprintFields;
            accesses = readAccesses;
            spaceMetadata = readSpaceMetadata;
            pageMetadata = readPageMetadata;
            pageBlueprints = readPageBlueprints;
            createSpaceGroups = readCreateSpaceGroups;
        }
    }

    public static void reset() {
        spaceBlueprints = null;
        blueprintFields = null;
        accesses = null;
        spaceMetadata = null;
        pageMetadata = null;
        pageBlueprints = null;
        createSpaceGroups = null;
    }

    protected static BrikitOrderedMap<String, Access> unpackAccesses(JSONArray accessesJSON) throws Exception {
        BrikitOrderedMap accesses = new BrikitOrderedMap();
        for (JSONObject accessObject : accessesJSON.objects()) {
            JSONObject accessJSON = accessObject.getAsJSONObject();
            String name = accessJSON.getString(NAME_KEY);
            JSONArray permissionsJSON = accessJSON.getJSONArray(PERMISSIONS_KEY);
            ArrayList<AccessPermission> permissions = new ArrayList<AccessPermission>();
            for (JSONObject permissionObject : permissionsJSON.objects()) {
                JSONObject permissionJSON = permissionObject.getAsJSONObject();
                BrikitList<String> spacePermissions = BlueprintDefinitions.valuesAsStrings(permissionJSON.getJSONArray(GRANT_KEY));
                String type = permissionJSON.getString(TYPE_KEY);
                String userOrGroup = ANONYMOUS.equalsIgnoreCase(type) ? "" : permissionJSON.getString(NAME_KEY);
                boolean createGroup = "group".equalsIgnoreCase(type) && permissionJSON.has(CREATE_KEY) && permissionJSON.getBoolean(CREATE_KEY);
                AccessPermission accessPermission = new AccessPermission(type, userOrGroup, (List<String>)spacePermissions, createGroup);
                permissions.add(accessPermission);
            }
            accesses.put((Object)name, (Object)new Access(name, permissions));
        }
        return accesses;
    }

    protected static BrikitOrderedMap<String, PageBlueprint> unpackPageBlueprints(JSONArray pageBlueprintsJSON, BrikitOrderedMap<String, BlueprintField> readBlueprintFields) throws Exception {
        BrikitOrderedMap pageBlueprints = new BrikitOrderedMap();
        for (JSONObject pageBlueprint : pageBlueprintsJSON.objects()) {
            PageBlueprintType type;
            boolean includeChildren;
            JSONObject pageBlueprintJSON = pageBlueprint.getAsJSONObject();
            String pageTitle = pageBlueprintJSON.getString(PAGE_TITLE_KEY);
            String name = pageBlueprintJSON.has(NAME_KEY) ? pageBlueprintJSON.getString(NAME_KEY) : pageTitle;
            String spaceKey = pageBlueprintJSON.getString(SPACE_KEY_KEY);
            String description = pageBlueprintJSON.getString(DESCRIPTION_KEY);
            boolean bl = includeChildren = pageBlueprintJSON.has(INCLUDE_CHILDREN_KEY) ? pageBlueprintJSON.getBoolean(INCLUDE_CHILDREN_KEY) : false;
            PageBlueprintType pageBlueprintType = pageBlueprintJSON.has(TYPE_KEY) ? PageBlueprintType.get(pageBlueprintJSON.getString(TYPE_KEY)) : (type = includeChildren ? PageBlueprintType.TREE : PageBlueprintType.PAGE);
            if (type == null) {
                type = PageBlueprintType.PAGE;
            }
            ArrayList<String> spaceCategories = pageBlueprintJSON.has(VISIBILITY_KEY) ? BlueprintDefinitions.valuesAsStrings(pageBlueprintJSON.getJSONArray(VISIBILITY_KEY)) : new ArrayList<String>();
            Long workflowIdLong = type == PageBlueprintType.PAGE && pageBlueprintJSON.has(WORKFLOW_ID) ? Long.valueOf(pageBlueprintJSON.getLong(WORKFLOW_ID)) : null;
            Integer workflowId = workflowIdLong == null ? null : Integer.valueOf(BrikitNumber.parseInteger((String)Long.toString(workflowIdLong)));
            ArrayList<BlueprintField> blueprintFields = new ArrayList<BlueprintField>();
            if (pageBlueprintJSON.has(BLUEPRINTS_FIELDS_KEY)) {
                JSONArray blueprintFieldsJSON = pageBlueprintJSON.getJSONArray(BLUEPRINTS_FIELDS_KEY);
                for (String id : blueprintFieldsJSON.strings()) {
                    BlueprintField blueprintField = (BlueprintField)readBlueprintFields.get((Object)id);
                    if (blueprintField == null) continue;
                    blueprintFields.add(blueprintField);
                }
            }
            pageBlueprints.put((Object)name, (Object)new PageBlueprint(name, spaceKey, pageTitle, description, blueprintFields, type, spaceCategories, workflowId));
        }
        return pageBlueprints;
    }

    protected static BrikitOrderedMap<String, SpaceBlueprint> unpackSpaceBlueprints(JSONArray spaceBlueprintsJSON, BrikitOrderedMap<String, BlueprintField> readBlueprintFields, BrikitOrderedMap<String, Access> allAccesses) throws Exception {
        BrikitOrderedMap spaceBlueprints = new BrikitOrderedMap();
        for (JSONObject spaceBlueprintJSON : spaceBlueprintsJSON.objects()) {
            String name = spaceBlueprintJSON.getString(NAME_KEY);
            String description = spaceBlueprintJSON.getString(DESCRIPTION_KEY);
            String categories = spaceBlueprintJSON.has(SPACE_CATEGORIES_KEY) ? spaceBlueprintJSON.getString(SPACE_CATEGORIES_KEY) : "";
            BrikitList spaceCategories = BrikitString.splitCommaSeparated((String)categories);
            String blueprintSpaceKey = spaceBlueprintJSON.getString(BLUEPRINT_SPACE_KEY_KEY);
            String spaceKey = spaceBlueprintJSON.has(SPACE_KEY_KEY) ? spaceBlueprintJSON.getString(SPACE_KEY_KEY) : "";
            String spaceName = spaceBlueprintJSON.has(SPACE_NAME_KEY) ? spaceBlueprintJSON.getString(SPACE_NAME_KEY) : "";
            String spaceDescription = spaceBlueprintJSON.has(SPACE_DESCRIPTION_KEY) ? spaceBlueprintJSON.getString(SPACE_DESCRIPTION_KEY) : "";
            JSONArray blueprintFieldsJSON = spaceBlueprintJSON.getJSONArray(BLUEPRINTS_FIELDS_KEY);
            ArrayList<BlueprintField> blueprintFields = new ArrayList<BlueprintField>();
            for (String id : blueprintFieldsJSON.strings()) {
                BlueprintField blueprintField = (BlueprintField)readBlueprintFields.get((Object)id);
                if (blueprintField == null) continue;
                blueprintFields.add(blueprintField);
            }
            JSONArray accessesJSON = spaceBlueprintJSON.getJSONArray(ACCESS_KEY);
            ArrayList<Access> accesses = new ArrayList<Access>();
            for (String accessName : accessesJSON.strings()) {
                Access access = (Access)allAccesses.get((Object)accessName);
                if (access == null) continue;
                accesses.add(access);
            }
            spaceBlueprints.put((Object)name, (Object)new SpaceBlueprint(name, description, (List<String>)spaceCategories, blueprintSpaceKey, spaceKey, spaceName, spaceDescription, blueprintFields, accesses));
        }
        return spaceBlueprints;
    }

    protected static BrikitOrderedMap<String, BlueprintField> unpackBlueprintFields(JSONArray blueprintFieldsJSON) throws Exception {
        BrikitOrderedMap blueprintFields = new BrikitOrderedMap();
        for (JSONObject blueprintFieldJSON : blueprintFieldsJSON.objects()) {
            String id = blueprintFieldJSON.getString(ID_KEY);
            String name = blueprintFieldJSON.getString(NAME_KEY);
            String type = blueprintFieldJSON.has(TYPE_KEY) ? blueprintFieldJSON.getString(TYPE_KEY) : "";
            String helpText = blueprintFieldJSON.has(HELP_TEXT_KEY) ? blueprintFieldJSON.getString(HELP_TEXT_KEY) : "";
            String placeholder = blueprintFieldJSON.has(PLACEHOLDER_KEY) ? blueprintFieldJSON.getString(PLACEHOLDER_KEY) : "";
            String validation = blueprintFieldJSON.has(VALIDATION_KEY) ? blueprintFieldJSON.getString(VALIDATION_KEY) : "";
            boolean required = blueprintFieldJSON.has(REQUIRED_KEY) && blueprintFieldJSON.getBoolean(REQUIRED_KEY);
            JSONArray values = blueprintFieldJSON.has(VALUES) ? blueprintFieldJSON.getJSONArray(VALUES) : new JSONArray();
            boolean multiselect = blueprintFieldJSON.has(MULTISELECT) && blueprintFieldJSON.getBoolean(MULTISELECT);
            boolean addLabels = blueprintFieldJSON.has(ADD_LABELS) && blueprintFieldJSON.getBoolean(ADD_LABELS);
            String filterGroup = blueprintFieldJSON.has(FILTER_GROUP) ? blueprintFieldJSON.getString(FILTER_GROUP) : "";
            BlueprintField blueprintField = BlueprintField.create(id, name, type, helpText, placeholder, validation, required, BlueprintDefinitions.valuesAsStrings(values), multiselect, addLabels, filterGroup);
            blueprintFields.put((Object)id, (Object)blueprintField);
        }
        return blueprintFields;
    }

    public static synchronized void uploadSettings(File uploadedFile) throws Exception {
        BlueprintDefinitions.readBlueprintsFromFile(uploadedFile, true);
        Files.move(uploadedFile.toPath(), BlueprintDefinitions.getBlueprintDefinitionsFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        BlueprintDefinitions.reset();
        BlueprintsUpdateClusterEvent event = new BlueprintsUpdateClusterEvent(new Object());
        Confluence.getEventPublisher().publish((Object)event);
    }

    public static BrikitList<String> valuesAsStrings(JSONArray values) {
        return new BrikitList(values.strings());
    }
}

