/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.brikit.blueprintmaker.actions.BlueprintMakerActionSupport;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.FieldValue;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.PageFields;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.blueprintmaker.model.SpaceFields;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitOrderedMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class BlueprintFieldsAction
extends BlueprintMakerActionSupport {
    public static final String SPACE_BLUEPRINT_PREFIX = "space:";
    public static final String PAGE_BLUEPRINT_PREFIX = "page:";
    protected String loadContext;
    protected boolean usingSpaceBlueprint;

    public String execute() throws Exception {
        return "success";
    }

    public String getLoadContext() {
        return this.loadContext;
    }

    public PageBlueprint getPageBlueprint() {
        return BlueprintDefinitions.getPageBlueprint(this.getLoadContext());
    }

    public BrikitOrderedMap<String, BlueprintField> getPageBlueprintFields() {
        PageBlueprint pageBlueprint = this.getPageBlueprint();
        return pageBlueprint == null ? new BrikitOrderedMap() : pageBlueprint.getAllBlueprintFields();
    }

    public SpaceBlueprint getSpaceBlueprint() {
        return BlueprintDefinitions.getSpaceBlueprint(this.getLoadContext());
    }

    public Map<String, FieldValue> getSpaceBlueprintFieldValues() {
        HashMap<String, FieldValue> values = new HashMap<String, FieldValue>();
        try {
            if (SpaceFields.isFromTemplate(this.getSpaceKey())) {
                values.putAll(SpaceFields.savedFieldsForSpace(this.getSpaceKey()).getValues());
            }
            if (PageFields.isFromTemplate(this.getPage())) {
                values.putAll(PageFields.savedFieldsForPage(this.getPage()).getValues());
            }
        }
        catch (Exception ex) {
            BrikitLog.logDebug((String)("Unable to read saved blueprint field values for space created from blueprint: " + this.getSpace()), (Exception)ex);
        }
        return values;
    }

    public BrikitOrderedMap<String, BlueprintField> getSpaceBlueprintFields() {
        SpaceBlueprint spaceBlueprint = this.getSpaceBlueprint();
        return spaceBlueprint == null ? null : spaceBlueprint.getAllBlueprintFields();
    }

    public boolean isUsingSpaceBlueprint() {
        return this.usingSpaceBlueprint;
    }

    @StrutsParameter
    public void setLoadContext(String loadContext) {
        if (loadContext.indexOf(":") == -1) {
            loadContext = SPACE_BLUEPRINT_PREFIX + loadContext;
        }
        this.setUsingSpaceBlueprint(loadContext.startsWith(SPACE_BLUEPRINT_PREFIX));
        this.loadContext = loadContext.substring(loadContext.indexOf(":") + 1);
    }

    @StrutsParameter
    public void setUsingSpaceBlueprint(boolean usingSpaceBlueprint) {
        this.usingSpaceBlueprint = usingSpaceBlueprint;
    }
}

