/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.ResourceAware;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.HashMap;
import java.util.Map;

public class LibraryIconMacro
extends BrikitNoBodyMacro
implements EditorImagePlaceholder,
ResourceAware {
    public static final String ICON_NAME_PARAM = "icon-name";
    public static final String ICON_COLOR_PARAM = "icon-color";
    public static final String ICON_SIZE_PARAM = "icon-size";
    public static final String FIELD_COLOR_PARAM = "field-color";
    public static final Map<String, Integer> iconSizes = new HashMap<String, Integer>(3);
    public static final Map<String, Float> borderSizes;
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/library-icon.vm";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        macroContext.velocityContextAdd((Object)"iconUrl", (Object)this.getImageLocation(parameters, conversionContext));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    protected String getColor(BrikitMacroContext macroContext, ThemeProperties themeProperties, String paramName, String defaultColor) {
        return macroContext.stringValue(paramName, defaultColor);
    }

    protected long getFieldSize(BrikitMacroContext macroContext) {
        return Math.round((double)this.getIconSize(macroContext.getParameters()) * 0.8);
    }

    protected String getIconName(BrikitMacroContext macroContext) {
        return macroContext.stringValue(ICON_NAME_PARAM);
    }

    protected int getIconSize(Map<String, String> params) {
        String sizeChoice = params.get(ICON_SIZE_PARAM);
        if (!BrikitString.isSet((String)sizeChoice)) {
            sizeChoice = "medium";
        }
        return iconSizes.get(sizeChoice);
    }

    public String getImageLocation(Map<String, String> params, ConversionContext ctx) {
        String path = Confluence.getContextPath() + "/plugins/servlet/themepress/brikitservlet/library/icons/";
        try {
            BrikitMacroContext macroContext = new BrikitMacroContext(params, "", ctx);
            ThemeProperties themeProperties = BrikitThemeSettings.getThemeProperties(macroContext.getSpace());
            path = path + themeProperties.getThemeName();
            path = path + "/" + this.getIconName(macroContext);
            path = path + "/" + this.getColor(macroContext, themeProperties, ICON_COLOR_PARAM, "whiteColor");
            int iconSize = this.getIconSize(params);
            path = path + "/" + iconSize;
            path = path + "/" + this.getImageSize(macroContext);
            if (this.hasField(macroContext)) {
                path = path + "/" + this.getColor(macroContext, themeProperties, FIELD_COLOR_PARAM, "primaryColor");
                path = path + "/" + this.getFieldSize(macroContext);
                path = path + "/" + this.getFieldSize(macroContext);
            }
        }
        catch (MacroExecutionException ex) {
            BrikitLog.logError((String)"Couldn't render Library Icon macro", (Exception)((Object)ex));
        }
        return path;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> params, ConversionContext ctx) {
        int size = this.getIconSize(params);
        return new DefaultImagePlaceholder(this.getImageLocation(params, ctx), false, new ImageDimensions(size, size));
    }

    protected long getImageSize(BrikitMacroContext macroContext) {
        long base = this.hasField(macroContext) ? this.getFieldSize(macroContext) : (long)this.getIconSize(macroContext.getParameters());
        return Math.round((double)base * 0.8);
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public String getResourcePath() {
        return null;
    }

    protected boolean hasField(BrikitMacroContext macroContext) {
        return macroContext.hasStringValue(FIELD_COLOR_PARAM);
    }

    public void setResourcePath(String s) {
    }

    static {
        iconSizes.put("small", 64);
        iconSizes.put("medium", 128);
        iconSizes.put("large", 256);
        borderSizes = new HashMap<String, Float>(3);
        borderSizes.put("small", Float.valueOf(1.5f));
        borderSizes.put("medium", Float.valueOf(3.0f));
        borderSizes.put("large", Float.valueOf(6.0f));
    }
}

