(function ($) { 

	// Make fieldset containers into expandable sections, that appear collapsed [disabled: when no values are in the contained fields]
	// If startCollapsed is true, force the container closed on initial setup
	$.fn.fieldsetContainerToggle = function(startCollapsed) {
		var toggle = function () {
			var $container = $(this).parents(".expanding-field-set-container");
			var $icon = $(".expand-control-icon", $container);
			var $fieldset = $("fieldset", $container);
			$icon.toggleClass("expanded");
			$fieldset.slideToggle("fast", function () {
				ThemePress.Events.fireCallbacks("fieldsetContainerToggled", $container);
			});
		};
		
        return this.each(function() {
			var $icon = $(".expand-control-icon", this).click(toggle);
			var $title = $(".field-set-toggle", this).click(toggle);
			var $fieldset = $("fieldset", this);
			// Don't open because of values
			var hasValues = false; // $fieldset.find("input, textarea, select").hasValues();
			var collapse = startCollapsed || (!$(".field-set-toggle", this).hasClass("no-auto-collapse") && !hasValues);
			if (collapse) $fieldset.addClass("field-set-hidden");
			else $icon.addClass("expanded");
        });
	};
	
	// Return true if the receiver is a fieldset toggle and is in the expanded (open) state
	$.fn.fieldsetToggleIsOpen = function () {
		var $toggle = $(this);
		var $container = $(this).parents(".expanding-field-set-container");
		return $(".expand-control-icon", $container).hasClass("expanded");
	};

	ThemePress.Events.addEventTypes("fieldsetContainerToggled");

})(jQuery);
