(function ($) {
	
	BrikitDesigner = function () {
		this.initialize();
	};
	
	var prototype = BrikitDesigner.prototype;
	
	prototype.availableDesigns = function ($element) {
		var used = this.designContexts($element);
		return ["feature", "red", "green", "blue", "hero-background"].diff(used);
	};
	
	prototype.appliedDesignsPicker = function (selector) {
		var $holder = $("#brikit-applied-designs");
		return selector ? $(selector, $holder) : $holder;
	};
	
	prototype.availableDesignsPicker = function (selector) {
		var $holder = $("#brikit-available-designs");
		return selector ? $(selector, $holder) : $holder;
	};
	
	prototype.contextNamesToListItems = function (names) {
		return $(names).map(function () { return $("<li>").append($("<span>").addClass("aui-lozenge aui-lozenge-subtle").text(this)); });
	};
	
	prototype.designContextChanged = function (event, ui) {
		var contexts = this.appliedDesignsPicker("span.aui-lozenge").map(function () { return $(this).text(); }).toArray();

		var $element = this.selectedElement();
		$element.data("design-context", contexts.join(","));

		$(this.availableDesigns($element)).each(function () { $element.removeClass(this + "-context"); });
		$(contexts).each(function () { $element.addClass(this + "-context"); });

		this.updateAfterChange();
	};
	
	prototype.designContextOptions = function () {
		return $("#brikit-design-context-options");
	};
	
	prototype.designContexts = function (element) {
		return $(element).data("design-context") ? $(element).data("design-context").split(/,\s*/) : [];
	};

	prototype.find = function (selector) {
		var $holder = $("#brikit-designer-holder");
		return selector ? $(selector, $holder) : $holder;
	};
	
	prototype.initialize = function () {
		var self = this;
		
		self.initializeLayoutThumbnail();
		
		self.find().on("click", "#brikit-page-layout-thumbnail .brikit-grid-item", function (e) { self.toggleFocus(e, $(this)); });
		self.find().on("click", "#brikit-page-layout-thumbnail .brikit-grid-container", function (e) { self.toggleFocus(e, $(this)); });
		
		if (self.openState()) self.toggle();
		
		self.initializeLayoutOptions();
		self.initializeDesignOptions();

		self.updateAfterChange();
	};
	
	prototype.initializeDesignOptions = function () {
		var self = this;
		
		$("#brikit-design-context-options").initializeExpander();

		self.appliedDesignsPicker(".sortable-items-field").sortable({
			connectWith: "#brikit-available-designs .sortable-items-field",
			containment: "#brikit-design-context-options",
			helper: "clone",
			revert: 100,
			stop: function (event, ui) { self.designContextChanged(event, ui); }
		});
		
		self.availableDesignsPicker(".sortable-items-field").sortable({
			connectWith: "#brikit-applied-designs .sortable-items-field",
			containment: "#brikit-design-context-options",
			helper: "clone",
			revert: 100,
			stop: function (event, ui) { self.designContextChanged(event, ui); }
		});

		$( ".sortable-items-field" ).disableSelection();
	};
	
	prototype.initializeLayoutOptions = function () {
		var self = this;
		
		$("#brikit-layout-selector").initializeExpander();
		
		$("#brikit-layout-options .sortable-items-field").on("click", "li", function (e) { self.layoutSelectionChanged(e, this); });
		
		
		$.get(
			ThemePress.contextPath + "/plugins/brikit/grid/layout/gridlayouts.action",
			{ pageId: ThemePress.pageId },
			function (response) {self.loadLayoutOptions(response); }
		);
	};
	
	prototype.initializeLayoutThumbnail = function () {
		var self = this;
		GridLayout.grids.each(function () {
			var $fullBleedSource = this.grid.closest(".brikit-grid-container-full-bleed");
			var $thumbnail = $fullBleedSource.clone();
			var $container = $thumbnail.find(".brikit-grid-container").empty().data("element", $fullBleedSource);
			$thumbnail.attr("class", "thumbnail-grid thumbnail-" + $container.attr("id")).removeAttr("id");
			// $thumbnail.find("style").remove();
			$(".brikit-grid-item", this.grid).each(function () {
				var $gridItem = $(this).clone().removeAttr("id").removeAttr("style").attr("class", "brikit-grid-item").css({"grid-area": $(this).css("grid-area")});
				$gridItem.empty().data("element", $(this)).text($gridItem.data("grid-area") || "content");
				$container.append($gridItem);
			});

			$("#brikit-page-layout-thumbnail").append($thumbnail);

		});
		
	};
	
	prototype.layoutSelectionChanged = function (event, layout) {
		var self = this;
		var $layout = $(layout);
		event.preventDefault();
		
		ThemePress.Dialog2.confirm("<p>" + ThemePress.getText("com.brikit.themepress.change.page.layout", [$layout.text(), $layout.data("page-url")]) + "</p>", 
			{ title: ThemePress.getText("com.brikit.themepress.change.layout"), okButton: ThemePress.getText("com.brikit.themepress.change.layout") },
			function () { ThemePress.PageTab.layoutPageSelectionChanged.call(layout, event); }
		);
	};
	
	prototype.layoutThumbnail = function (selector) {
		var $thumbnail = $("#brikit-page-layout-thumbnail");
		return selector ? $(selector, $thumbnail) : $thumbnail;
	};
	
	prototype.loadLayoutOptions = function (response) {
		$("#brikit-layout-options .sortable-items-field").append(response);
	};
	
	prototype.openState = function (open) {
		var self = this;
	    if (ThemePress.PresentationMode.isPresentationMode()) self.openState(false);
		else if (typeof(open) != "undefined") ThemePress.cookie(ThemePress.SimpleDesigner.openCookie, open ? "open" : "closed", 60);
		
		var open = ThemePress.cookie(ThemePress.SimpleDesigner.openCookie);
		return open == null && self.find(".evaluating").length || open == "open";
	};
	
	prototype.selectedElement = function () {
		return this.selectedThumbnail().closest(".brikit-grid-item, .brikit-grid-container").data("element");
	};

	prototype.selectedThumbnail = function () {
		return $("#brikit-page-layout-thumbnail .selected");
	};

	prototype.toggle = function () {
		if (this.selectedElement()) this.selectedThumbnail().click();
		
		$("body").toggleClass("designer-in");
		this.openState($("body").hasClass("designer-in"));
	};
	
	prototype.toggleFocus = function (e, $element) {
		var self = this;
		e.stopPropagation();
		e.preventDefault();
		
		if ($element.hasClass("selected")) {
			$element.removeClass("selected");
		}
		else {
			self.find("#brikit-page-layout-thumbnail  .selected").removeClass("selected");
			$element.addClass("selected");
		}
		self.updateAfterChange();
	};

	prototype.updateAfterChange = function () {
		var self = this;
		
		self.designContextOptions().slideOpenIf(self.selectedElement());

		if (self.selectedElement()) {
			self.appliedDesignsPicker("ul").empty();
			self.availableDesignsPicker("ul").empty();
		
			self.contextNamesToListItems(self.designContexts(self.selectedElement())).each(function () { self.appliedDesignsPicker("ul").append(this); } );
			self.contextNamesToListItems(self.availableDesigns(self.selectedElement()).sort()).each(function () { self.availableDesignsPicker("ul").append(this); } );
		}
		
		self.updateFocusBlanket();
		
	};
	
	prototype.updateFocusBlanket = function () {
		if (this.selectedElement()) ThemePress.Focus.showFocusBlanket(this.selectedElement());
		else ThemePress.Focus.hideFocusBlanket();
	};

	

	ThemePress.SimpleDesigner = {
		designer: false,
		openCookie: "com.brikit.simple.designer.open",
		toggleDesigner: function () { if (ThemePress.SimpleDesigner.designer) ThemePress.SimpleDesigner.designer.toggle(); }
	}
	
	ThemePress.toInit(function ($) {
	});
	
	ThemePress.toFinalize(function ($) {
		if (!$("#brikit-simplified-designer").length) return;
		console.log("Found a simplified designer.");
		
		ThemePress.SimpleDesigner.designer = new BrikitDesigner();
		ThemePress.SimpleDesigner.designer.find().addClass("initialized");
		ThemePress.registerCookie(ThemePress.SimpleDesigner.openCookie);	
	})

})(jQuery);
