/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.topictree.model.TopicTree;
import java.util.Map;

public class TopicTreeMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/topic-tree.vm";
    public static final String SPACE_FILTER_PARAM = "space-filter";
    public static final String SPACE_CATEGORIES_PARAM = "space-categories";
    public static final String EXCLUDE_SPACE_CATEGORIES_PARAM = "exclude-space-categories";
    public static final String LABELS_PARAM = "labels";
    public static final String LABEL_NAMES_PARAM = "label-names";
    public static final String CONVERT_PAGE_LABELS = "convert-page-labels";
    public static final String INCLUDE_PAGES_PARAM = "include-pages";
    public static final String INCLUDE_BLOGPOSTS_PARAM = "include-blogposts";
    public static final String INCLUDE_FILES_PARAM = "include-files";
    public static final String MAX_RESULTS_PER_LABEL_PARAM = "max-results-per-label";
    public static final int DEFAULT_MAX_RESULTS = 10;

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.hasStringValue("key") && !Confluence.isSpace((String)macroContext.stringValue("key"))) {
            throw new MacroExecutionException("Specified space key '" + macroContext.stringValue("key") + "' does not exist.");
        }
        if (!(macroContext.booleanValue(INCLUDE_PAGES_PARAM) || macroContext.booleanValue(INCLUDE_BLOGPOSTS_PARAM) || macroContext.booleanValue(INCLUDE_FILES_PARAM))) {
            throw new MacroExecutionException("No content types specified. Choose to include pages, blogposts, and/or files.");
        }
        Space space = macroContext.hasStringValue("key") ? macroContext.spaceFromValue("key") : macroContext.getSpace();
        macroContext.velocityContextAdd((Object)"labelList", (Object)macroContext.commaSeparatedListValue(LABELS_PARAM));
        Map<String, String> labelTitles = TopicTree.labelTitles(macroContext.getPage(), macroContext.stringValue(LABELS_PARAM), macroContext.stringValue(LABEL_NAMES_PARAM));
        macroContext.velocityContextAdd((Object)"labelTitles", labelTitles);
        String topic = Confluence.getHttpRequestParameter((String)"topic");
        if (!BrikitString.isSet((String)topic)) {
            for (String label : macroContext.commaSeparatedListValue(LABELS_PARAM)) {
                if (!Confluence.hasLabel((AbstractLabelableEntityObject)macroContext.getPage(), (String)label)) continue;
                topic = label;
                break;
            }
        }
        macroContext.velocityContextAdd((Object)"topic", (Object)topic);
        if (!macroContext.hasStringValue(MAX_RESULTS_PER_LABEL_PARAM)) {
            macroContext.velocityContextAdd((Object)MAX_RESULTS_PER_LABEL_PARAM, (Object)10);
        }
        macroContext.velocityContextAdd((Object)"space", (Object)space);
        macroContext.velocityContextAdd((Object)"topic-tree-id", (Object)this.localSafeId("topic-tree"));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public boolean isInline() {
        return true;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

