/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeJavaScriptCacheHelper;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThemeJavaScriptCache {
    public static final String BASE_CODE_KEY = "base";
    public static final String CUSTOM_CODE_KEY = "theme";
    public static final String DESIGNER_KEY = "designer";
    public static final String EDIT_KEY = "edit";
    protected static long compiledAt = 0L;
    protected static Cache<String, String> cache;
    protected static CacheSettings cacheSettings;

    public static String getBundleName(String themeName, String tweaker, boolean customCode, boolean skipDesignerSupport) {
        return themeName + "~~~" + tweaker + "~~~" + (customCode ? CUSTOM_CODE_KEY : BASE_CODE_KEY) + "~~~" + ThemeJavaScriptCache.skipDesignerSupportKey(skipDesignerSupport);
    }

    protected static Cache<String, String> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache(Confluence.getText((String)"com.brikit.themepress.theme.js.cache"), (CacheLoader)new CacheLoader<String, String>(){

                public String load(String cacheKey) {
                    ThemeJavaScriptCacheHelper cacheHelper = new ThemeJavaScriptCacheHelper(cacheKey);
                    String themeName = cacheHelper.getThemeName();
                    StringBuilder buffer = new StringBuilder(500000);
                    if (cacheHelper.isCustomCode()) {
                        String javascriptFromTheme = ThemeProperties.getThemeProperties(themeName).getJavascriptFiles();
                        BrikitThemeSettings.readJavascriptFiles(buffer, cacheHelper.filesFromTheme(), themeName, "Theme Custom Code");
                    } else {
                        Map<String, String> i18nPropertiesFiles = BrikitThemeSettings.javascriptI18nPropertiesFiles();
                        BrikitThemeSettings.updateJavascriptI18nProperties(i18nPropertiesFiles);
                        BrikitThemeSettings.readJavascriptFiles(buffer, cacheHelper.filesFromThemePress(), themeName, "Brikit Theme Press");
                        BrikitThemeSettings.readJavascriptFiles(buffer, cacheHelper.filesFromPlugins(), themeName, "Third-Party Theme Press Plugin");
                    }
                    return buffer.toString();
                }
            }, cacheSettings);
        }
        return cache;
    }

    public static long getCompiledAt() {
        return compiledAt;
    }

    public static String getJavaScript(String cacheKey) {
        ThemeJavaScriptCacheHelper cacheHelper = new ThemeJavaScriptCacheHelper(cacheKey, ThemeJavaScriptCache.getCompiledAt());
        if (cacheHelper.needsUpdate()) {
            ThemeJavaScriptCache.reset(cacheKey);
        }
        return (String)ThemeJavaScriptCache.getCache().get((Object)cacheKey);
    }

    protected static void reset(String cacheKey) {
        ThemeJavaScriptCache.getCache().remove((Object)cacheKey);
    }

    public static void reset() {
        ThemeJavaScriptCache.getCache().removeAll();
    }

    protected static String skipDesignerSupportKey(boolean skipDesignerSupport) {
        return skipDesignerSupport ? EDIT_KEY : DESIGNER_KEY;
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(5L, TimeUnit.HOURS).maxEntries(50).build();
    }
}

