/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.license;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.brikit.core.confluence.Confluence;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class LicenseBugCache {
    protected static Cache<String, Long> cache;
    protected static CacheSettings cacheSettings;

    protected static Cache<String, Long> getCache() {
        if (cache == null) {
            cache = Confluence.getCacheManager().getCache("Brikit Theme Press Defer License Warning", (CacheLoader)new LicenseBugCacheLoader(), cacheSettings);
        }
        return cache;
    }

    public static boolean doNotBug(String sessionId) throws ExecutionException {
        long age = new Date().getTime() - (Long)LicenseBugCache.getCache().get((Object)sessionId);
        return age > 0L;
    }

    public static void reset() {
        LicenseBugCache.getCache().removeAll();
    }

    static {
        cacheSettings = new CacheSettingsBuilder().remote().expireAfterAccess(2L, TimeUnit.MINUTES).maxEntries(100).build();
    }

    protected static class LicenseBugCacheLoader
    implements CacheLoader<String, Long> {
        protected LicenseBugCacheLoader() {
        }

        @Nonnull
        public Long load(@Nonnull String sessionId) {
            return new Date().getTime();
        }
    }
}

