/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ThemePluginAccess {
    protected static final String THEME_ACCESS_GROUPS = "com.brikit.themepress.access.groups.theme";
    protected static final String THEME_DELIMITER = ":::";

    public static void addThemeAccessGroup(String group, String themeName) {
        BrikitList<String> groups = ThemePluginAccess.themeAccessGroups(themeName);
        if (groups.contains((Object)group)) {
            return;
        }
        groups.add((Object)group);
        ThemePluginAccess.saveThemeAccessGroups(groups, themeName);
    }

    public static boolean hasThemeAccess(String themeName) {
        return ThemePluginAccess.hasThemeAccess(themeName, ThemePluginAccess.themeAccessGroups(themeName));
    }

    public static boolean hasThemeAccessWithoutGroup(String themeName, String group) {
        BrikitList<String> groups = ThemePluginAccess.themeAccessGroups(themeName);
        groups.remove((Object)group);
        return ThemePluginAccess.hasThemeAccess(themeName, groups);
    }

    protected static boolean hasThemeAccess(String themeName, BrikitList<String> groups) {
        return Confluence.isConfluenceAdministrator() || BrikitString.isSet((String)themeName) && (groups.isEmpty() || Confluence.isGroupMember(groups));
    }

    public static void removeThemeAccessGroup(String group, String themeName) {
        BrikitList<String> groups = ThemePluginAccess.themeAccessGroups(themeName);
        if (!groups.contains((Object)group)) {
            return;
        }
        groups.remove((Object)group);
        ThemePluginAccess.saveThemeAccessGroups(groups, themeName);
    }

    protected static void saveThemeAccessGroups(BrikitList<String> groups, String themeName) {
        Map<String, BrikitList> themeAccessGroups = ThemePluginAccess.themeAccessGroups();
        themeAccessGroups.put(themeName, groups);
        ThemePluginAccess.saveThemeAccessGroups(themeAccessGroups);
    }

    protected static void saveThemeAccessGroups(Map<String, BrikitList> themeAccessGroups) {
        BrikitList themes = new BrikitList();
        for (String theme : themeAccessGroups.keySet()) {
            BrikitList groups = themeAccessGroups.get(theme);
            if (groups.isEmpty()) continue;
            BrikitList parts = new BrikitList();
            parts.add((Object)theme);
            parts.addAll((Collection)groups);
            themes.add((Object)parts.join(","));
        }
        BrikitBandanaManager.saveEntry(null, (String)THEME_ACCESS_GROUPS, (Object)themes.join(THEME_DELIMITER));
    }

    public static BrikitList<String> themeAccessGroups(String themeName) {
        BrikitList themeEntry = ThemePluginAccess.themeAccessGroups().get(themeName);
        return themeEntry == null ? new BrikitList() : themeEntry;
    }

    protected static Map<String, BrikitList> themeAccessGroups() {
        HashMap<String, BrikitList> themeAccessGroups = new HashMap<String, BrikitList>();
        String accessString = BrikitBandanaManager.getEntry(null, (String)THEME_ACCESS_GROUPS);
        for (String themeAccessString : BrikitString.split((String)accessString, (String)THEME_DELIMITER)) {
            BrikitList parts = BrikitString.splitCommaSeparated((String)themeAccessString);
            if (parts.size() < 2) continue;
            themeAccessGroups.put((String)parts.first(), parts.objectsAfter((Object)((String)parts.first())));
        }
        return themeAccessGroups;
    }
}

