/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.AttachmentUploadRequest;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.LoadDesignerAction;
import java.awt.image.BufferedImage;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SelectAttachedImageAction
extends LoadDesignerAction {
    protected String imageName;
    protected BufferedImage bufferedImage;
    protected List<String> pageImages;

    public String getImageName() {
        return this.imageName;
    }

    public List<String> getPageImages() {
        if (this.pageImages == null) {
            this.pageImages = Confluence.getImageAttachmentNames((AbstractPage)this.getPage());
        }
        return this.pageImages;
    }

    public boolean hasImageName() {
        return BrikitString.isSet((String)this.getImageName());
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String remove() {
        Attachment attachment = Confluence.getAttachment((AbstractPage)this.getPage(), (String)this.getImageName());
        if (attachment == null) {
            this.addActionError("Attachment " + this.getImageName() + " not found on " + this.getPage());
            return "error";
        }
        if (!Confluence.canRemove((Attachment)attachment)) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
            return "error";
        }
        Confluence.removeAttachment((Attachment)attachment);
        return "success";
    }

    @StrutsParameter
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String upload() {
        if (this.getMultiPartRequest() == null) {
            return "input";
        }
        AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(this.getMultiPartRequest());
        for (AttachmentResource resource : uploadRequest.getResources()) {
            Confluence.getFileUploadManager().storeResource(resource, (ContentEntityObject)this.getPage());
        }
        return "success";
    }
}

