/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.designer.ThemePluginAccess;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.settings.ThemeProperties;
import java.io.File;
import java.util.List;

public class AbstractThemeFileAction
extends ThemePressActionSupport {
    protected String filename;
    protected String fileContents;
    protected String fileExtension;
    protected ThemeProperties themeProperties;

    public String jsonSuccess() {
        JSONObject json = new JSONObject();
        json.put("success", true);
        json.put("filename", (Object)this.getFilename());
        json.put("fileExtension", (Object)this.getFileExtension());
        this.setJSONSuccess(json);
        return "success";
    }

    public String getFileContents() {
        return this.fileContents;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public List<String> getFileNames() throws Exception {
        return BrikitString.split((String)this.getThemeProperty(this.getFileNamesProperty()));
    }

    public String getFileNamesProperty() {
        return this.isCSS() ? "brikitCustomCSS" : "brikitCustomJavaScript";
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilenameWithoutExtension() {
        return BrikitFile.nameWithoutExtension((String)this.getFilename());
    }

    public String getMode() {
        return this.isCSS() ? "css" : "javascript";
    }

    protected File getThemeFile() {
        return ThemePlugin.getThemeResourceFile(this.getThemeName(), this.getThemeFilename());
    }

    protected String getThemeFilename() {
        String themeFilename = (this.isCSS() ? "css" : "scripts") + BrikitFile.separator() + this.getFilename();
        if (!themeFilename.endsWith("." + this.getFileExtension())) {
            themeFilename = themeFilename + "." + this.getFileExtension();
        }
        return themeFilename;
    }

    protected ThemeProperties getThemeProperties() {
        if (this.themeProperties == null) {
            this.themeProperties = ThemeProperties.getThemeProperties(this.getThemeName());
        }
        return this.themeProperties;
    }

    protected String getThemeProperty(String key) {
        return this.getThemeProperties().get(key);
    }

    public boolean isCSS() {
        return "css".equals(this.getFileExtension());
    }

    public void setFileContents(String fileContents) {
        this.fileContents = fileContents;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void validate() {
        super.validate();
        if (!ThemePluginAccess.hasThemeAccess(this.getThemeName())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

