/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.topictree.actions;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.ContentFilteringMacro;
import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.params.ParameterException;
import com.atlassian.confluence.macro.query.BooleanQueryFactory;
import com.atlassian.confluence.macro.query.InclusionCriteria;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldNames;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.CreatorQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LabelledContentMacro
extends ContentFilteringMacro {
    private static final Logger log = Logger.getLogger(LabelledContentMacro.class);
    private static final String TEMPLATE_NAME = "com/atlassian/confluence/plugins/macros/advanced/labelledcontent.vm";
    private static final String SPACE_ALL = "@all";
    private static final String SPACE_SELF = "@self";
    private static final String WHERE_PARAM = "where";
    private static final String SPACE_ALL_KEYWORD = "conf_all";
    private static final String OPERATOR = "operator";
    private static final String OPERATOR_OR = "OR";
    private static final String OPERATOR_AND = "AND";
    private static final String DELIMITERS_REGEX = "[, ]+";
    private static final String QUERY_STRING_PARAM = "queryString";
    private static final String[] LABEL_KEYS = new String[]{"labels", "label", ""};
    private static final String LABEL_PREFIX = "labelText";
    private static final String[] SPACES = new String[]{"spaces", "space"};
    private static final String SPACE_PREFIX = "spacekey";
    private static final String[] TYPE_KEYS = new String[]{"type"};
    private static final String TYPE_PREFIX = "type";
    private ExcerptHelper excerptHelper;
    private Renderer viewRenderer;
    private ConfluenceActionSupport confluenceActionSupport;
    private WebResourceManager webResourceManager;

    public LabelledContentMacro() {
        this.labelParam.setValidate(false);
        this.spaceKeyParam.addParameterAlias("key");
        this.spaceKeyParam.setDefaultValue(SPACE_ALL);
        this.labelParam.addParameterAlias("0");
        this.maxResultsParam.addParameterAlias("maxResults");
        this.maxResultsParam.setDefaultValue("15");
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(MacroExecutionContext ctx) throws MacroException {
        SearchResults searchResults;
        SearchSort searchSort;
        this.webResourceManager.requireResource("confluence.macros.advanced:content-by-label-resources");
        Map<String, Object> contextMap = this.getMacroVelocityContext();
        Map parameters = ctx.getParams();
        String title = (String)parameters.get("title");
        BooleanQueryFactory queryFactory = new BooleanQueryFactory();
        boolean limitLabelLinksToSpace = false;
        BooleanQueryFactory spaceKeyQuery = (BooleanQueryFactory)this.spaceKeyParam.findValue(ctx);
        if (spaceKeyQuery != null) {
            queryFactory.addMust((SearchQuery)spaceKeyQuery.toBooleanQuery());
            limitLabelLinksToSpace = this.isSingleSpace(spaceKeyQuery);
        }
        if (parameters.containsKey(OPERATOR) && ((String)parameters.get(OPERATOR)).equalsIgnoreCase(OPERATOR_AND)) {
            this.labelParam.setDefaultInclusionCriteria(InclusionCriteria.ALL);
        } else {
            this.labelParam.setDefaultInclusionCriteria(InclusionCriteria.ANY);
        }
        BooleanQueryFactory labelQuery = (BooleanQueryFactory)this.labelParam.findValue(ctx);
        if (labelQuery == null) {
            throw new MacroException(this.getConfluenceActionSupport().getText("contentbylabel.error.label-parameter-required"));
        }
        queryFactory.addMust((SearchQuery)labelQuery.toBooleanQuery());
        ArrayList<String> labelNames = new ArrayList<String>();
        labelNames.add(this.labelParam.getParameterValue(parameters));
        contextMap.put("labelNames", labelNames);
        try {
            searchSort = (SearchSort)this.sortParam.findValue(ctx);
        }
        catch (ParameterException pe) {
            throw new MacroException(this.getConfluenceActionSupport().getText("contentbylabel.error.parse-reverse-or-sort-param"), (Throwable)pe);
        }
        try {
            BooleanQueryFactory contentTypeQuery = (BooleanQueryFactory)this.contentTypeParam.findValue(ctx);
            if (contentTypeQuery != null) {
                queryFactory.addMust((SearchQuery)contentTypeQuery.toBooleanQuery());
            }
        }
        catch (ParameterException pe) {
            throw new MacroException(this.getConfluenceActionSupport().getText("contentbylabel.error.parse-types-param", new String[]{StringEscapeUtils.escapeHtml((String)pe.getMessage())}), (Throwable)pe);
        }
        Set authors = (Set)this.authorParam.findValue(ctx);
        if (!authors.isEmpty()) {
            BooleanQueryFactory authorQueryFactory = new BooleanQueryFactory();
            for (String author : authors) {
                authorQueryFactory.addShould((SearchQuery)new CreatorQuery(author));
            }
            queryFactory.addMust((SearchQuery)authorQueryFactory.toBooleanQuery());
        }
        BooleanQuery query = queryFactory.toBooleanQuery();
        Integer maxResults = (Integer)this.maxResultsParam.findValue(ctx);
        ContentSearch search = new ContentSearch((SearchQuery)query, searchSort, 0, maxResults.intValue());
        try {
            searchResults = this.searchManager.search((ISearch)search, SearchFieldNames.withDefaultValues());
        }
        catch (InvalidSearchException ise) {
            throw new MacroException(this.getConfluenceActionSupport().getText("contentbylabel.error.run-search"), (Throwable)ise);
        }
        List contents = this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION);
        contextMap.put("title", title);
        contextMap.put("contents", contents);
        contextMap.put("unfilteredResultsCnt", searchResults.getUnfilteredResultsCount());
        contextMap.put("showLabels", this.getBooleanParameter((String)parameters.get("showLabels"), true));
        contextMap.put("showSpace", this.getBooleanParameter((String)parameters.get("showSpace"), true));
        contextMap.put("limitLabelLinksToSpace", limitLabelLinksToSpace);
        contextMap.put("excerptHelper", new ExcerptRendererHelper(Boolean.valueOf((String)parameters.get("excerpt")), this.excerptHelper, this.viewRenderer));
        String searchPagesByLabelsURL = this.createSearchPagesByLabelsURL(this.getCurrentSpace(ctx.getPageContext().getEntity()), parameters);
        contextMap.put("searchPagesByLabelsURL", searchPagesByLabelsURL);
        return this.render(contextMap);
    }

    private String createSearchPagesByLabelsURL(Space currentSpace, Map<String, String> params) {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        StringBuilder queryString = new StringBuilder();
        queryString.append(settingsManager.getGlobalSettings().getBaseUrl() + "/dosearchsite.action?");
        String spaceKey = "";
        String spaceQuery = null;
        String[] spaceValues = this.getValues(params, SPACES);
        if (spaceValues == null) {
            spaceKey = SPACE_ALL_KEYWORD;
        } else if (spaceValues.length == 1) {
            String spaceValue = spaceValues[0];
            spaceKey = SPACE_ALL.equals(spaceValue) ? SPACE_ALL_KEYWORD : (SPACE_SELF.equals(spaceValue) ? (currentSpace == null ? SPACE_ALL_KEYWORD : currentSpace.getKey()) : spaceValue);
        } else {
            spaceKey = SPACE_ALL_KEYWORD;
            spaceQuery = this.createQuery(params, SPACES, SPACE_PREFIX, OPERATOR_OR);
        }
        queryString.append("where=" + spaceKey);
        queryString.append("&queryString=");
        String labelOperation = OPERATOR_OR;
        if (OPERATOR_AND.equals(params.get(OPERATOR))) {
            labelOperation = OPERATOR_AND;
        }
        String labelsQuery = this.createQuery(params, LABEL_KEYS, LABEL_PREFIX, labelOperation);
        String typesQuery = this.createQuery(params, TYPE_KEYS, TYPE_PREFIX, OPERATOR_OR);
        Joiner.on((String)" AND ").skipNulls().appendTo(queryString, (Object)spaceQuery, (Object)labelsQuery, new Object[]{typesQuery});
        return queryString.toString();
    }

    private Space getCurrentSpace(ContentEntityObject ceo) {
        Space currentSpace = null;
        if (ceo instanceof Spaced) {
            currentSpace = ((Spaced)ceo).getSpace();
        }
        return currentSpace;
    }

    private String[] getValues(Map<String, String> params, String[] keys) {
        for (String key : keys) {
            if (!params.containsKey(key)) continue;
            return params.get(key).split(DELIMITERS_REGEX);
        }
        return null;
    }

    private String createQuery(Map<String, String> params, String[] keys, String prefix, String operation) {
        String[] values = this.getValues(params, keys);
        if (values != null) {
            String query = "(";
            for (String value : values) {
                query = query + prefix + ":" + value + " " + operation + " ";
            }
            query = query.substring(0, query.lastIndexOf(operation) - 1);
            query = query + ")";
            return query;
        }
        return null;
    }

    private boolean isSingleSpace(BooleanQueryFactory spaceKeyQuery) {
        boolean limitLabelLinksToSpace = false;
        List params = spaceKeyQuery.toBooleanQuery().getParameters();
        if (params.size() == 1 && params.get(0) instanceof InSpaceQuery) {
            limitLabelLinksToSpace = true;
        }
        return limitLabelLinksToSpace;
    }

    protected Map<String, Object> getMacroVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String render(Map<String, Object> contextMap) {
        return VelocityUtils.getRenderedTemplate((String)TEMPLATE_NAME, contextMap);
    }

    private Boolean getBooleanParameter(String booleanValue, boolean defaultValue) {
        if (StringUtils.isNotBlank((String)booleanValue)) {
            return Boolean.valueOf(booleanValue);
        }
        return defaultValue;
    }

    public void setViewRenderer(Renderer viewRenderer) {
        this.viewRenderer = viewRenderer;
    }

    public void setExcerptHelper(ExcerptHelper excerptHelper) {
        this.excerptHelper = excerptHelper;
    }

    protected ConfluenceActionSupport getConfluenceActionSupport() {
        if (null == this.confluenceActionSupport) {
            this.confluenceActionSupport = GeneralUtil.newWiredConfluenceActionSupport();
        }
        return this.confluenceActionSupport;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public class ExcerptRendererHelper {
        private final ExcerptHelper helper;
        private final Renderer renderer;
        private final boolean showExcerpts;

        private ExcerptRendererHelper(boolean showExcerpts, ExcerptHelper helper, Renderer renderer) {
            this.helper = helper;
            this.renderer = renderer;
            this.showExcerpts = showExcerpts;
        }

        public boolean shouldRenderExcerpt(ContentEntityObject entity) {
            return this.showExcerpts && StringUtils.isNotBlank((String)this.helper.getExcerpt(entity));
        }

        public String getRenderedExcerpt(ContentEntityObject entity) {
            return this.renderer.render(this.helper.getExcerpt(entity), (ConversionContext)new DefaultConversionContext((RenderContext)entity.toPageContext()));
        }
    }
}

