/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.designer.ThemeChangeset;
import com.brikit.themepress.designer.ThemeDevelopmentTimeout;
import com.brikit.themepress.settings.ThemePlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class ThemeUndoStack {
    protected static final String CURRENT_MARKER = ">>>> CURRENT <<<<";
    protected static final String END_MARKER = ">>>> END <<<<";
    protected File cacheFile;
    protected static Map themes;
    protected String themeName;
    protected BrikitList changesets;
    protected ThemeChangeset current;

    protected static Map<String, ThemeUndoStack> getThemes() {
        if (themes == null) {
            themes = new HashMap();
        }
        return themes;
    }

    public static ThemeUndoStack getUndoStack(String themeName) {
        ThemeUndoStack undoStack = ThemeUndoStack.getThemes().get(themeName);
        if (undoStack == null) {
            undoStack = new ThemeUndoStack(themeName);
            ThemeUndoStack.getThemes().put(themeName, undoStack);
        }
        return undoStack;
    }

    protected ThemeUndoStack(String themeName) {
        this.themeName = themeName;
    }

    public JSONObject getJSONObject(String key, String value) {
        JSONObject json = new JSONObject();
        json.put(key, (Object)value);
        return json;
    }

    public ThemeChangeset addChange(String property, String oldValue, String newValue) {
        return this.addChange(this.getJSONObject(property, BrikitString.trimToString(oldValue)).toString(), this.getJSONObject(property, BrikitString.trimToString(newValue)).toString());
    }

    public ThemeChangeset addChange(String oldValuesJSON, String newValuesJSON) {
        if (this.getChangesets() != null) {
            this.getChangesets().removeAll(this.getChangesets().objectsAfter(this.getCurrent()));
        }
        ThemeChangeset changeset = new ThemeChangeset(oldValuesJSON, newValuesJSON);
        this.getChangesets().add(changeset);
        this.setCurrent((ThemeChangeset)this.getChangesets().last());
        this.saveChangeSet();
        return changeset;
    }

    protected void saveChangeSet() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (Object next : this.getChangesets()) {
                ThemeChangeset changeset = (ThemeChangeset)next;
                builder.append(changeset.toJSON().toString());
                builder.append(",");
                builder.append(BrikitString.lineSeparator());
                if (!changeset.equals(this.getCurrent())) continue;
                JSONObject marker = new JSONObject();
                marker.put(CURRENT_MARKER, (Object)CURRENT_MARKER);
                builder.append(marker.toString());
                builder.append(",");
                builder.append(BrikitString.lineSeparator());
            }
            JSONObject marker = new JSONObject();
            marker.put(END_MARKER, (Object)END_MARKER);
            builder.append(marker.toString());
            builder.append("]");
            BrikitFile.write(builder.toString(), this.getCacheFile());
            ThemeDevelopmentTimeout.resetTimeout();
        }
        catch (IOException ex) {
            BrikitLog.logError("Failed to save Undo Stack change set.", ex);
        }
    }

    public String getThemeName() {
        return this.themeName;
    }

    protected BrikitList getChangesets() {
        if (this.changesets == null) {
            this.changesets = new BrikitList();
            try {
                String cacheContents = BrikitFile.readFile(this.getCacheFile());
                JSONArray jsonArray = new JSONArray(BrikitString.isSet(cacheContents) ? cacheContents : "[]");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject json = jsonArray.getJSONObject(i);
                    if (json.has(CURRENT_MARKER)) {
                        this.setCurrent((ThemeChangeset)this.getChangesets().last());
                        continue;
                    }
                    if (json.has(END_MARKER)) continue;
                    this.changesets.add(new ThemeChangeset(json));
                }
            }
            catch (IOException ex) {
                BrikitLog.logError("Failed to read theme name from change set.", ex);
            }
        }
        return this.changesets;
    }

    protected ThemeChangeset getCurrent() {
        return this.current;
    }

    protected File getCacheFile() {
        if (this.cacheFile == null) {
            this.cacheFile = BrikitFile.getBrikitFile(this.getThemeName() + "-undostack.json");
        }
        return this.cacheFile;
    }

    public boolean hasRedo() {
        return this.nextRedo() != null;
    }

    public boolean hasUndo() {
        return this.getCurrent() != null;
    }

    public ThemeChangeset nextRedo() {
        return (ThemeChangeset)(this.getCurrent() == null ? this.getChangesets().first() : this.getChangesets().after(this.getCurrent()));
    }

    public ThemeChangeset nextUndo() {
        return this.hasUndo() ? this.getCurrent() : null;
    }

    protected void setCurrent(ThemeChangeset current) {
        this.current = current;
    }

    public void redo() throws IOException, ExecutionException {
        if (!this.hasRedo()) {
            return;
        }
        ThemeChangeset next = this.nextRedo();
        ThemePlugin.apply(this.getThemeName(), next.getNewValues());
        this.setCurrent(next);
        this.saveChangeSet();
    }

    public void reset() {
        BrikitFile.removeFile(this.getCacheFile());
        this.changesets = null;
    }

    public void undo() throws IOException, ExecutionException {
        if (!this.hasUndo()) {
            return;
        }
        ThemePlugin.apply(this.getThemeName(), this.getCurrent().getOldValues());
        this.setCurrent(this.getChangesets().before(this.getCurrent()));
        this.saveChangeSet();
    }
}

