/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.comalaworkflowsservice;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventPublisher;
import com.brikit.core.comalaworkflowsservice.BlogPostPublishedEvent;
import com.brikit.core.comalaworkflowsservice.ComalaAccessor;
import com.brikit.core.comalaworkflowsservice.PagePublishedEvent;
import com.brikit.core.log.BrikitLog;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;

public class Comala {
    protected Object approvalService;
    protected Object stateService;
    protected Object taskService;
    protected Object workflowService;

    public Comala(Object approvalService, Object stateService, Object taskService, Object workflowService) {
        this.approvalService = Preconditions.checkNotNull((Object)approvalService, (Object)"approvalService");
        this.stateService = Preconditions.checkNotNull((Object)stateService, (Object)"stateService");
        this.taskService = Preconditions.checkNotNull((Object)taskService, (Object)"taskService");
        this.workflowService = Preconditions.checkNotNull((Object)workflowService, (Object)"workflowService");
    }

    public Object getApprovalService() {
        return this.approvalService;
    }

    public Object getStateService() {
        return this.stateService;
    }

    public Object getTaskService() {
        return this.workflowService;
    }

    public Object getWorkflowService() {
        return this.workflowService;
    }

    public Integer getPublishedVersion(ContentEntityObject ceo) {
        try {
            Method getCurrentStateMethod = ComalaAccessor.getStateServiceClass().getMethod("getCurrentState", ContentEntityObject.class);
            Object currentState = getCurrentStateMethod.invoke(this.stateService, ceo);
            Method getActiveWorkflowsMethod = ComalaAccessor.getWorkflowServiceClass().getMethod("getActiveWorkflows", ContentEntityObject.class);
            List activeWorkflows = (List)getActiveWorkflowsMethod.invoke(this.workflowService, ceo);
            if (currentState == null || activeWorkflows.size() == 0) {
                return ceo.getVersion();
            }
            Method getPublishedStateMethod = ComalaAccessor.getStateServiceClass().getMethod("getPublishedState", ContentEntityObject.class);
            Object publishedState = getPublishedStateMethod.invoke(this.stateService, ceo);
            if (publishedState == null) {
                return null;
            }
            Method publishedVersionMethod = publishedState.getClass().getMethod("getVersion", new Class[0]);
            return (Integer)publishedVersionMethod.invoke(publishedState, new Object[0]);
        }
        catch (Exception ex) {
            BrikitLog.logDebug("Failed Comala Workflows method invocation", ex);
            return null;
        }
    }

    public void handleEvent(Event event, EventPublisher eventPublisher) {
        try {
            Method getStateMethod;
            Object state;
            Method isPublishedMethod;
            Boolean isPublished;
            if (event.getClass() == ComalaAccessor.getStateChangeEventClass() && (isPublished = (Boolean)(isPublishedMethod = (state = (getStateMethod = ComalaAccessor.getStateChangeEventClass().getMethod("getState", new Class[0])).invoke((Object)event, new Object[0])).getClass().getMethod("isPublished", new Class[0])).invoke(state, new Object[0])).booleanValue()) {
                Method getContentMethod = event.getClass().getMethod("getContent", new Class[0]);
                Object content = getContentMethod.invoke((Object)event, new Object[0]);
                this.handlePublishEvent(content, eventPublisher);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handlePublishEvent(Object content, EventPublisher eventPublisher) {
        if (content instanceof Page) {
            eventPublisher.publish((Object)new PagePublishedEvent("Comala Workflows Service", (Page)content));
        } else if (content instanceof BlogPost) {
            eventPublisher.publish((Object)new BlogPostPublishedEvent("Comala Workflows Service", (BlogPost)content));
        }
    }
}

