/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.BrikitDataStore;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.SafeId;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.Folksonomy;
import com.brikit.targetedsearch.model.SearchSettings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterGroup
implements Comparable {
    protected static final String UNRESTRICTED_KEY = "com.brikit.targetedsearch.unrestricted.visibility";
    protected static final String SAFE_ID_KEY = "safeId";
    protected static final String DISPLAY_KEY = "displayString";
    protected static final String VISIBLE_TO_KEY = "visibleTo";
    protected static final String EXCLUDE_FROM_KEY = "excludeFrom";
    protected static final String LABEL_PREFIX_KEY = "labelPrefix";
    protected static final String PROMOTED_KEY = "promoted";
    protected static final String FILTERS_KEY = "filters";
    protected static final String FILTERS_WITH_SUBCATEGORIES_KEY = "filtersWithSubcategories";
    protected static Map<String, List<FilterGroup>> spaceCategoryToFilterGroups;
    protected static Map<String, List<FilterGroup>> excludeFromSpaceCategoryFilterGroups;
    protected static Map<String, FilterGroup> filterGroupsByKey;
    protected static Map<String, FilterGroup> filterGroupsByName;
    private static List<FilterGroup> filterGroups;
    private String key;
    private String displayName;
    private String labelPrefix;
    private List<Filter> filters;
    private List<Filter> promotedFilters;
    private List<Filter> unpromotedFilters;
    private List<String> visibleTo;
    private List<String> excludeFrom;
    private Filter parentFilter;
    private boolean promoted;

    public FilterGroup(JSONObject settings) {
        this(settings.getString(SAFE_ID_KEY), settings.getString(DISPLAY_KEY), (List<String>)new BrikitList(settings.getJSONArray(VISIBLE_TO_KEY).strings()), (List<String>)new BrikitList(settings.has(EXCLUDE_FROM_KEY) ? settings.getJSONArray(EXCLUDE_FROM_KEY).strings() : Collections.EMPTY_LIST), settings.has(LABEL_PREFIX_KEY) ? settings.getString(LABEL_PREFIX_KEY) : null, settings.has(PROMOTED_KEY) && BrikitBoolean.booleanValue((String)settings.getString(PROMOTED_KEY)));
        this.filters = Filter.getFilters(this, (JSONArray)settings.get(FILTERS_KEY));
    }

    public FilterGroup(String displayName) {
        this(displayName, null, null, null, false);
    }

    public FilterGroup(String displayName, List<String> visibleTo, List<String> excludeFrom, String labelPrefix, boolean promoted) {
        this(null, displayName, visibleTo, excludeFrom, labelPrefix, promoted);
    }

    public FilterGroup(String key, String displayName, List<String> visibleTo, List<String> excludeFrom, String labelPrefix, boolean promoted) {
        this.key = key;
        this.displayName = displayName;
        this.visibleTo = visibleTo == null ? new ArrayList() : visibleTo;
        this.excludeFrom = excludeFrom == null ? new ArrayList() : excludeFrom;
        this.labelPrefix = labelPrefix;
        this.promoted = promoted;
    }

    public static void addImportedFilterGroup(FilterGroup rehydratedFilterGroup) {
        FilterGroup.getFilterGroups().add(rehydratedFilterGroup);
        FilterGroup.getFilterGroupsByName().put(rehydratedFilterGroup.getDisplayName().toLowerCase(), rehydratedFilterGroup);
    }

    public static Map<String, List<FilterGroup>> getExcludeFromSpaceCategoryFilterGroups() {
        if (excludeFromSpaceCategoryFilterGroups == null) {
            FilterGroup.getFilterGroups();
        }
        return excludeFromSpaceCategoryFilterGroups;
    }

    protected static List<FilterGroup> getExcludedFilterGroupsForSpaceLabel(String label) {
        List<FilterGroup> groups = FilterGroup.getExcludeFromSpaceCategoryFilterGroups().get(label);
        return groups == null ? Collections.EMPTY_LIST : groups;
    }

    public static FilterGroup getFilterGroupByKey(String key) {
        return FilterGroup.getFilterGroupsByKey().get(key);
    }

    public static FilterGroup getFilterGroupByName(String displayName) {
        return FilterGroup.getFilterGroupsByName().get(displayName.toLowerCase());
    }

    public static BrikitList<FilterGroup> getFilterGroupsByName(List<String> filterGroupNames) {
        BrikitList filterGroups = new BrikitList();
        for (String filterGroupName : filterGroupNames) {
            FilterGroup filterGroup = FilterGroup.getFilterGroupByName(filterGroupName);
            if (filterGroup == null) {
                filterGroup = FilterGroup.getFilterGroupByKey(filterGroupName);
            }
            if (filterGroup == null) continue;
            filterGroups.add((Object)filterGroup);
        }
        return filterGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<FilterGroup> getFilterGroups() {
        if (filterGroups != null) return filterGroups;
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            if (filterGroups != null) return filterGroups;
            filterGroups = new ArrayList<FilterGroup>();
            JSONArray data = SearchSettings.getTargetedSearchData();
            for (JSONObject groupData : data.objects()) {
                FilterGroup filterGroup = new FilterGroup(groupData);
                filterGroups.add(filterGroup);
            }
            FilterGroup.initializeFilterGroupDictionaries(FilterGroup.getFilterGroups());
            FilterGroup.initializeFilterGroupVisibilityMapping();
            Filter.initializeFiltersDictionaries();
            // ** MonitorExit[var0] (shouldn't be in output)
            return filterGroups;
        }
    }

    protected static Map<String, FilterGroup> getFilterGroupsByKey() {
        if (filterGroupsByKey == null) {
            filterGroupsByKey = new HashMap<String, FilterGroup>();
        }
        return filterGroupsByKey;
    }

    protected static Map<String, FilterGroup> getFilterGroupsByName() {
        if (filterGroupsByName == null) {
            filterGroupsByName = new HashMap<String, FilterGroup>();
        }
        return filterGroupsByName;
    }

    public static List<FilterGroup> getFilterGroupsForSpace(Space space) {
        return FilterGroup.getFilterGroupsForSpace(space == null ? null : space.getKey());
    }

    protected static List<FilterGroup> getFilterGroupsForSpaceLabel(String label) {
        List<FilterGroup> groups = FilterGroup.getSpaceCategoryToFilterGroups().get(label);
        return groups == null ? Collections.EMPTY_LIST : groups;
    }

    public static BrikitList<FilterGroup> getFilterGroupsForSpace(String spaceKey) {
        BrikitList availableFilterGroups = new BrikitList();
        availableFilterGroups.addAll(FilterGroup.getFilterGroupsForSpaceLabel(UNRESTRICTED_KEY));
        for (String spaceLabel : Confluence.getLabelsForSpace((String)spaceKey)) {
            availableFilterGroups.ensureContains(FilterGroup.getFilterGroupsForSpaceLabel(spaceLabel));
        }
        for (String spaceLabel : Confluence.getLabelsForSpace((String)spaceKey)) {
            availableFilterGroups.removeAll(FilterGroup.getExcludedFilterGroupsForSpaceLabel(spaceLabel));
        }
        return availableFilterGroups;
    }

    public static Map<String, List<FilterGroup>> getSpaceCategoryToFilterGroups() {
        if (spaceCategoryToFilterGroups == null) {
            FilterGroup.getFilterGroups();
        }
        return spaceCategoryToFilterGroups;
    }

    private static void initializeFilterGroupDictionaries(List<FilterGroup> filterGroups) {
        for (FilterGroup filterGroup : filterGroups) {
            FilterGroup.getFilterGroupsByKey().put(filterGroup.getKey(), filterGroup);
            FilterGroup.getFilterGroupsByName().put(filterGroup.getDisplayName().toLowerCase(), filterGroup);
            for (Filter filter : filterGroup.getFilters()) {
                if (filter.isPromoted()) {
                    filterGroup.getPromotedFilters().add(filter);
                } else {
                    filterGroup.getUnpromotedFilters().add(filter);
                }
                FilterGroup.initializeFilterGroupDictionaries(filter.getSubcategories());
            }
            if (!filterGroup.getPromotedFilters().isEmpty()) continue;
            filterGroup.getPromotedFilters().addAll(filterGroup.getUnpromotedFilters());
            filterGroup.getUnpromotedFilters().clear();
        }
    }

    protected static List<FilterGroup> getExcludeFromFilterGroups(String spaceLabel) {
        List<FilterGroup> mappedFilterGroups = excludeFromSpaceCategoryFilterGroups.get(spaceLabel);
        if (mappedFilterGroups == null) {
            mappedFilterGroups = new ArrayList<FilterGroup>();
            excludeFromSpaceCategoryFilterGroups.put(spaceLabel, mappedFilterGroups);
        }
        return mappedFilterGroups;
    }

    protected static List<FilterGroup> getVisibleToFilterGroups(String spaceLabel) {
        List<FilterGroup> mappedFilterGroups = spaceCategoryToFilterGroups.get(spaceLabel);
        if (mappedFilterGroups == null) {
            mappedFilterGroups = new ArrayList<FilterGroup>();
            spaceCategoryToFilterGroups.put(spaceLabel, mappedFilterGroups);
        }
        return mappedFilterGroups;
    }

    protected static void initializeFilterGroupVisibilityMapping() {
        spaceCategoryToFilterGroups = new HashMap<String, List<FilterGroup>>();
        excludeFromSpaceCategoryFilterGroups = new HashMap<String, List<FilterGroup>>();
        ArrayList<String> unrestrictedLabels = new ArrayList<String>(1);
        unrestrictedLabels.add(UNRESTRICTED_KEY);
        FilterGroup.getVisibleToFilterGroups(UNRESTRICTED_KEY);
        for (FilterGroup filterGroup : FilterGroup.getFilterGroups()) {
            List<Object> visibleToLabels = !filterGroup.getVisibleTo().isEmpty() ? filterGroup.getVisibleTo() : unrestrictedLabels;
            for (String string : visibleToLabels) {
                FilterGroup.getVisibleToFilterGroups(string).add(filterGroup);
            }
            for (String string : filterGroup.getExcludeFrom()) {
                FilterGroup.getExcludeFromFilterGroups(string).add(filterGroup);
            }
        }
    }

    public static void resetCaches() {
        FilterGroup.resetCaches(true);
    }

    public static synchronized void resetCaches(boolean immediateRebuild) {
        if (immediateRebuild) {
            filterGroups = null;
            spaceCategoryToFilterGroups = null;
            filterGroupsByKey = null;
            filterGroupsByName = null;
            Filter.resetCaches();
            FilterGroup.getFilterGroups();
        } else {
            filterGroups = new ArrayList<FilterGroup>();
            spaceCategoryToFilterGroups = new HashMap<String, List<FilterGroup>>();
            filterGroupsByKey = new HashMap<String, FilterGroup>();
            filterGroupsByName = new HashMap<String, FilterGroup>();
            Filter.resetCaches();
        }
    }

    public static void saveFilterCategoryOrder(List<String> filterCategories) {
        BrikitDataStore.setString((String)"", (String)"filterCategoryOrder", (String)new BrikitList(filterCategories).join(","));
    }

    public static void saveFilterGroups() {
        FilterGroup.saveFilterGroups(FilterGroup.getFilterGroups());
    }

    public static synchronized void saveFilterGroups(List<FilterGroup> filterGroups) {
        JSONArray settingsData = new JSONArray();
        for (FilterGroup filterGroup : filterGroups) {
            settingsData.put((Object)filterGroup.toJSONObject());
        }
        SearchSettings.saveSettings(settingsData);
        FilterGroup.resetCaches();
    }

    public void addExcludeFrom(String spaceLabel) {
        if (spaceLabel != null && !this.getExcludeFrom().contains(spaceLabel)) {
            this.getExcludeFrom().add(spaceLabel);
        }
    }

    public void addFilter(Filter filter) {
        this.getFilters().add(filter);
    }

    public synchronized void addFilterAndSave(Filter filter) {
        this.addFilter(filter);
        Folksonomy.delete(filter.getLabel());
        FilterGroup.saveFilterGroups();
    }

    public void addVisibleTo(String spaceLabel) {
        if (spaceLabel != null && !this.getVisibleTo().contains(spaceLabel)) {
            this.getVisibleTo().add(spaceLabel);
        }
    }

    public int compareTo(Object anotherFilterGroup) throws ClassCastException {
        if (!(anotherFilterGroup instanceof FilterGroup)) {
            throw new ClassCastException("Expected a FilterGroup instance in attempt to compare.");
        }
        String anotherFilterGroupName = ((FilterGroup)anotherFilterGroup).getDisplayName();
        List<String> order = FilterGroup.filterCategoryOrder();
        int index = order.indexOf(this.getDisplayName());
        int otherIndex = order.indexOf(anotherFilterGroupName);
        if (index == -1 && otherIndex > -1) {
            return 1;
        }
        if (index > -1) {
            return otherIndex > -1 ? index - otherIndex : -1;
        }
        return this.getDisplayName().compareToIgnoreCase(anotherFilterGroupName);
    }

    public void delete() {
        if (this.getParentFilter() != null) {
            this.getParentFilter().deleteSubcategory(this);
        }
        FilterGroup.getFilterGroups().remove(this);
    }

    protected void deleteFilter(Filter filter) {
        this.getFilters().remove(filter);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterGroup filterGroup = (FilterGroup)obj;
        return this.key.equals(filterGroup.getKey());
    }

    public static List<String> filterCategoryOrder() {
        return BrikitString.split((String)BrikitDataStore.getString((String)"", (String)"filterCategoryOrder"), (String)",");
    }

    protected JSONObject filterlessJSONObject() {
        JSONObject json = new JSONObject();
        json.put(SAFE_ID_KEY, (Object)(this.isNew() ? SafeId.globalSafeId() : this.getKey()));
        json.put(DISPLAY_KEY, (Object)this.getDisplayName());
        json.put(VISIBLE_TO_KEY, this.getVisibleTo());
        json.put(EXCLUDE_FROM_KEY, this.getExcludeFrom());
        json.put(LABEL_PREFIX_KEY, (Object)this.getLabelPrefix());
        json.put(PROMOTED_KEY, this.isPromoted());
        return json;
    }

    public int getDepth() {
        int depth;
        Filter ancestor = this.getParentFilter();
        for (depth = 0; depth < 10 && ancestor != null; ++depth) {
            ancestor = ancestor.getParent().getParentFilter();
        }
        return depth;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getExcludeFrom() {
        return this.excludeFrom;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        return this.filters;
    }

    public BrikitList<Filter> getFiltersWithSubcategories() {
        BrikitList labels = new BrikitList();
        for (Filter filter : this.getSortedFilters()) {
            labels.add((Object)filter);
            for (FilterGroup subCategory : filter.getSubcategories()) {
                labels.addAll(subCategory.getFiltersWithSubcategories());
            }
        }
        return labels;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public Filter getParentFilter() {
        return this.parentFilter;
    }

    public BrikitList<String> getParentFilterGroupKeys() {
        BrikitList keys = new BrikitList();
        Filter parent = this.getParentFilter();
        while (parent != null) {
            keys.add((Object)parent.getParent().getKey());
            parent = parent.getParent().getParentFilter();
        }
        return keys;
    }

    public List<Filter> getPromotedFilters() {
        if (this.promotedFilters == null) {
            this.promotedFilters = new ArrayList<Filter>();
        }
        return this.promotedFilters;
    }

    public List<Filter> getSortedFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>(this.getFilters());
        Collections.sort(filters);
        return filters;
    }

    public List<Filter> getUnpromotedFilters() {
        if (this.unpromotedFilters == null) {
            this.unpromotedFilters = new ArrayList<Filter>();
        }
        return this.unpromotedFilters;
    }

    public List<String> getVisibleTo() {
        return this.visibleTo;
    }

    public boolean hasLabelPrefix() {
        return BrikitString.isSet((String)this.getLabelPrefix());
    }

    public boolean hasParentFilter() {
        return this.getParentFilter() != null;
    }

    public boolean isNew() {
        return !BrikitString.isSet((String)this.getKey());
    }

    public boolean isPromoted() {
        return this.promoted;
    }

    public synchronized void removeExcludeFromSetting(String spaceLabel) {
        this.getExcludeFrom().remove(spaceLabel);
    }

    public synchronized void removeVisibleToSetting(String spaceLabel) {
        this.getVisibleTo().remove(spaceLabel);
    }

    public void setDisplayName(String displayName) {
        this.displayName = BrikitString.trimToString((String)displayName);
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setParentFilter(Filter parentFilter) {
        this.parentFilter = parentFilter;
    }

    public void setPromoted(boolean promoted) {
        this.promoted = promoted;
    }

    public JSONObject toJSONObject() {
        JSONObject json = this.filterlessJSONObject();
        BrikitList filters = new BrikitList(this.getFilters());
        Collections.sort(filters);
        json.put(FILTERS_KEY, (Object)Filter.toJSONArray((List<Filter>)filters));
        json.put(FILTERS_WITH_SUBCATEGORIES_KEY, (Object)Filter.toJSONArray(this.getFiltersWithSubcategories()));
        return json;
    }

    public List<String> validate() {
        FilterGroup existing;
        ArrayList<String> errors = new ArrayList<String>();
        if (!BrikitString.isSet((String)this.getDisplayName())) {
            errors.add(Confluence.getText((String)"com.brikit.targetedsearch.settings.filtergroup.null"));
        }
        if ((existing = FilterGroup.getFilterGroupByName(this.getDisplayName())) != null && !existing.getKey().equalsIgnoreCase(this.getKey())) {
            String errorMssg = MessageFormat.format(Confluence.getText((String)"com.brikit.targetedsearch.settings.filtergroup.duplicate"), existing.getDisplayName());
            errors.add(errorMssg);
        }
        return errors;
    }
}

