/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.brikit.core.util.BrikitFile;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.AttachmentsExporter;
import java.io.File;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class DownloadAttachmentsAction
extends AbstractTargetedSearchAction {
    private static final String SETTINGS_FILENAME = "attachments.zip";
    private static final String ZIP_FILE_PATTERN = "download{0}{1,time,HHmmss}";
    protected List<String> attachmentIds;
    protected String downloadPath;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        AttachmentsExporter exporter = new AttachmentsExporter(this.getAttachmentIds());
        exporter.exportAttachments();
        this.setDownloadPath(BrikitFile.prepareDownloadPath((String)exporter.getZipFile().getPath()) + "?contentType=application/zip");
        BrikitFile.allowUserToDownload((File)exporter.getZipFile());
        return "success";
    }

    public List<String> getAttachmentIds() {
        return this.attachmentIds;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    @StrutsParameter
    public void setAttachmentIds(List<String> attachmentIds) {
        this.attachmentIds = attachmentIds;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }
}

