/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.json.jsonorg.JSONArray;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.SearchSettings;
import java.util.List;

public class Folksonomy {
    protected static BrikitList<String> folksonomy;

    public static void addLabel(String label) {
        if (!BrikitString.isSet((String)(label = Folksonomy.adjustLabel(label))) || Folksonomy.isOnList(label) || Filter.getFilterByLabel(label) != null) {
            return;
        }
        Folksonomy.getFolksonomy().add((Object)label);
        Folksonomy.saveFolksonomy();
    }

    public static String adjustLabel(String label) {
        return label.toLowerCase().trim();
    }

    public static BrikitList<String> adjustLabels(List<String> labels) {
        BrikitList adjustedLabels = new BrikitList(labels.size());
        for (String label : labels) {
            adjustedLabels.add((Object)Folksonomy.adjustLabel(label));
        }
        return adjustedLabels;
    }

    public static void addLabels(List<String> labels) {
        for (String label : labels) {
            Folksonomy.addLabel(label);
        }
    }

    public static void delete(String label) {
        Folksonomy.delete(label, true);
    }

    public static void delete(String label, boolean saveImmediately) {
        label = Folksonomy.adjustLabel(label);
        if (!Folksonomy.getFolksonomy().contains((Object)label)) {
            return;
        }
        Folksonomy.getFolksonomy().remove((Object)label);
        if (saveImmediately) {
            Folksonomy.saveFolksonomy();
        }
    }

    public static synchronized BrikitList<String> getFolksonomy() {
        if (folksonomy == null) {
            folksonomy = new BrikitList();
            for (String label : SearchSettings.getFolksonomy().strings()) {
                folksonomy.add((Object)Folksonomy.adjustLabel(label));
            }
        }
        return folksonomy;
    }

    public static synchronized BrikitList<String> getFolksonomyCopy() {
        return new BrikitList(Folksonomy.getFolksonomy());
    }

    public static boolean isOnList(String label) {
        return BrikitString.isSet((String)(label = Folksonomy.adjustLabel(label))) && Folksonomy.getFolksonomy().contains((Object)label);
    }

    public static synchronized void resetCache() {
        folksonomy = null;
        Folksonomy.getFolksonomy();
    }

    public static synchronized void saveFolksonomy() {
        SearchSettings.saveFolksonomy(Folksonomy.toJSONObject());
        Folksonomy.resetCache();
    }

    private static JSONArray toJSONObject() {
        JSONArray json = new JSONArray();
        for (String label : Folksonomy.getFolksonomy()) {
            json.put((Object)label);
        }
        return json;
    }
}

