/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.AttachmentUploadRequest;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;

public class UploadAttachmentsAction
extends AbstractTargetedSearchAction {
    protected String labels;

    @Override
    public String execute() {
        if (this.getMultiPartRequest() == null) {
            return "input";
        }
        AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(this.getMultiPartRequest());
        for (AttachmentResource resource : uploadRequest.getResources()) {
            Confluence.getFileUploadManager().storeResource(resource, (ContentEntityObject)this.getPage());
            Attachment attachment = Confluence.getAttachment(this.getPage(), resource.getFilename());
            Confluence.addLabels(BrikitString.split(this.getLabels()), attachment);
        }
        return "success";
    }

    public String getLabels() {
        return this.labels;
    }

    @Override
    public String getSpaceKey() {
        return Confluence.getSpaceKey(this.getPage());
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void validate() {
        super.validate();
        if (this.getPage() == null) {
            this.addActionError(Confluence.getText("com.brikit.targetedsearch.macros.validation.page.not.found"));
        }
        if (!Confluence.hasCreatePermission(this.getPage(), Attachment.class)) {
            this.addActionError(Confluence.getText("config.insufficient.permissions"));
        }
    }
}

