/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.tiles;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.security.Permission;
import com.brikit.core.confluence.BrikitVelocityContext;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.pinboards.cache.RenderedContentCache;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.model.PinType;
import com.brikit.pinboards.model.PinboardFeed;
import com.brikit.pinboards.tiles.AttachmentTile;
import com.brikit.pinboards.tiles.CommentTile;
import com.brikit.pinboards.tiles.LikeTile;
import com.brikit.pinboards.tiles.PageTile;
import com.brikit.pinboards.tiles.ShareTile;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

public abstract class Tile {
    protected FeedEntry feedEntry;
    protected ConfluenceEntityObject content;
    protected ConfluenceActionSupport action;

    protected Tile(FeedEntry feedEntry, ConfluenceEntityObject content, ConfluenceActionSupport action) {
        this.feedEntry = feedEntry;
        this.content = content;
        this.action = action;
    }

    public static Tile get(FeedEntry feedEntry, ConfluenceEntityObject ceo, ConfluenceActionSupport action) {
        if (!Confluence.hasPermission((Permission)Permission.VIEW, (Object)ceo)) {
            return null;
        }
        if (ceo instanceof ContentEntityObject && ((ContentEntityObject)ceo).isDeleted()) {
            return null;
        }
        if (feedEntry.getPinType() == PinType.LIKE) {
            return new LikeTile(feedEntry, ceo, action);
        }
        if (feedEntry.getPinType() == PinType.SHARE) {
            return new ShareTile(feedEntry, ceo, action);
        }
        if (ceo instanceof AbstractPage) {
            return new PageTile(feedEntry, (ConfluenceEntityObject)((AbstractPage)ceo), action);
        }
        if (ceo instanceof Attachment) {
            return new AttachmentTile(feedEntry, (ConfluenceEntityObject)((Attachment)ceo), action);
        }
        if (ceo instanceof Comment) {
            return new CommentTile(feedEntry, (ConfluenceEntityObject)((Comment)ceo), action);
        }
        PinboardFeed.removeFromFeeds(feedEntry);
        BrikitLog.logWarning((String)("Couldn't find content for feed entry: " + feedEntry));
        return null;
    }

    public static Tile get(FeedEntry feedEntry, ConfluenceActionSupport action) {
        HibernateHandle handle;
        try {
            handle = new HibernateHandle(feedEntry.getHandle());
        }
        catch (ParseException ex) {
            BrikitLog.logError((String)("Failed to parse object handle: " + feedEntry.getHandle()));
            return null;
        }
        ConfluenceEntityObject ceo = Confluence.getEntityFor((Handle)handle);
        return Tile.get(feedEntry, ceo, action);
    }

    public ConfluenceActionSupport getAction() {
        return this.action;
    }

    public ConfluenceEntityObject getContent() {
        return this.content;
    }

    public FeedEntry getFeedEntry() {
        return this.feedEntry;
    }

    protected abstract AbstractPage getPageContext();

    public abstract String getRenderedContent() throws IOException;

    public String getRenderedTile() throws IOException {
        if (this.getPageContext() == null) {
            return null;
        }
        String renderedContent = RenderedContentCache.cachedContent(this.getFeedEntry());
        if (renderedContent != null) {
            return renderedContent;
        }
        renderedContent = this.renderVelocityTemplate(this.getTemplateLocation(), this.getRenderedContent());
        RenderedContentCache.cacheContent(renderedContent, this.getFeedEntry());
        return renderedContent;
    }

    public abstract String getTemplateLocation();

    protected Map<String, Object> getVelocityContext(String renderedContent) {
        Map velocityContext = BrikitVelocityContext.getDefaultVelocityContext();
        velocityContext.put("contextPath", Confluence.getContextPath());
        velocityContext.put("action", this.getAction());
        velocityContext.put("user", Confluence.getConfluenceUser());
        velocityContext.put("contentHTML", renderedContent);
        velocityContext.put("ceo", this.getContent());
        velocityContext.put("feedEntry", this.getFeedEntry());
        return velocityContext;
    }

    protected String renderVelocityTemplate(String template, Map velocityContext) throws IOException {
        return Confluence.renderWithVelocityContext((String)template, (Map)velocityContext);
    }

    protected String renderVelocityTemplate(String template, String renderedContent) throws IOException {
        return this.renderVelocityTemplate(template, this.getVelocityContext(renderedContent));
    }
}

