/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.PageActivity;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import java.util.Collections;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PageViewCountReportAction
extends ContentFlowActionSupport {
    protected int days;
    protected BrikitList<Entry> results;

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        BrikitMap<String, Integer> counts = PageActivity.getPageViewCounts(this.getActiveObjects(), this.getSpaceKey(), this.getDays());
        BrikitList results = new BrikitList();
        for (String pageId : counts.keySet()) {
            results.add((Object)new Entry(pageId, (Integer)counts.get((Object)pageId)));
        }
        Collections.sort(results);
        this.setResults((BrikitList<Entry>)results);
        return "success";
    }

    public int getDays() {
        return this.days;
    }

    public BrikitList<Entry> getResults() {
        return this.results;
    }

    @StrutsParameter
    public void setDays(int days) {
        this.days = days;
    }

    public void setResults(BrikitList<Entry> results) {
        this.results = results;
    }

    public void validate() {
        super.validate();
        if (!Confluence.canAdministerSpace((String)this.getSpaceKey())) {
            this.addActionError(this.getText("config.insufficient.permissions"));
        }
    }

    public class Entry
    implements Comparable {
        public String pageId;
        public Integer count;

        public Entry(String pageId, Integer count) {
            this.pageId = pageId;
            this.count = count;
        }

        public int compareTo(Object o) {
            return ((Entry)o).count.compareTo(this.count);
        }

        public Integer getCount() {
            return this.count;
        }

        public String getPageId() {
            return this.pageId;
        }
    }
}

